<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageDGRV1 StructType
 * @subpackage Structs
 */
class PackageDGRV1 extends AbstractStructBase
{
    /**
     * The packageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelDGRV1[]
     */
    public $parcels;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusInfoDGRV1
     */
    public $statusInfo;
    /**
     * Constructor method for packageDGRV1
     * @uses PackageDGRV1::setPackageId()
     * @uses PackageDGRV1::setParcels()
     * @uses PackageDGRV1::setReference()
     * @uses PackageDGRV1::setStatusInfo()
     * @param int $packageId
     * @param \StructType\ParcelDGRV1[] $parcels
     * @param string $reference
     * @param \StructType\StatusInfoDGRV1 $statusInfo
     */
    public function __construct($packageId = null, array $parcels = array(), $reference = null, \StructType\StatusInfoDGRV1 $statusInfo = null)
    {
        $this
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \StructType\PackageDGRV1
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelDGRV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageDGRV1ParcelsItem) {
            // validation for constraint: itemType
            if (!$packageDGRV1ParcelsItem instanceof \StructType\ParcelDGRV1) {
                $invalidValues[] = is_object($packageDGRV1ParcelsItem) ? get_class($packageDGRV1ParcelsItem) : sprintf('%s(%s)', gettype($packageDGRV1ParcelsItem), var_export($packageDGRV1ParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \StructType\ParcelDGRV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelDGRV1[] $parcels
     * @return \StructType\PackageDGRV1
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelDGRV1 $item
     * @return \StructType\PackageDGRV1
     */
    public function addToParcels(\StructType\ParcelDGRV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelDGRV1) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \StructType\ParcelDGRV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\PackageDGRV1
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \StructType\StatusInfoDGRV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \StructType\StatusInfoDGRV1 $statusInfo
     * @return \StructType\PackageDGRV1
     */
    public function setStatusInfo(\StructType\StatusInfoDGRV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
