<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generateSpedLabelsV1 StructType
 * Meta information extracted from the WSDL
 * - type: tns:generateSpedLabelsV1
 * @subpackage Structs
 */
class GenerateSpedLabelsV1 extends AbstractStructBase
{
    /**
     * The dpdServicesParamsV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DpdServicesParamsV1
     */
    public $dpdServicesParamsV1;
    /**
     * The outputDocFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocFormatV1;
    /**
     * The outputDocPageFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocPageFormatV1;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generateSpedLabelsV1
     * @uses GenerateSpedLabelsV1::setDpdServicesParamsV1()
     * @uses GenerateSpedLabelsV1::setOutputDocFormatV1()
     * @uses GenerateSpedLabelsV1::setOutputDocPageFormatV1()
     * @uses GenerateSpedLabelsV1::setAuthDataV1()
     * @param \StructType\DpdServicesParamsV1 $dpdServicesParamsV1
     * @param string $outputDocFormatV1
     * @param string $outputDocPageFormatV1
     * @param \StructType\AuthDataV1 $authDataV1
     */
    public function __construct(\StructType\DpdServicesParamsV1 $dpdServicesParamsV1 = null, $outputDocFormatV1 = null, $outputDocPageFormatV1 = null, \StructType\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setDpdServicesParamsV1($dpdServicesParamsV1)
            ->setOutputDocFormatV1($outputDocFormatV1)
            ->setOutputDocPageFormatV1($outputDocPageFormatV1)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get dpdServicesParamsV1 value
     * @return \StructType\DpdServicesParamsV1|null
     */
    public function getDpdServicesParamsV1()
    {
        return $this->dpdServicesParamsV1;
    }
    /**
     * Set dpdServicesParamsV1 value
     * @param \StructType\DpdServicesParamsV1 $dpdServicesParamsV1
     * @return \StructType\GenerateSpedLabelsV1
     */
    public function setDpdServicesParamsV1(\StructType\DpdServicesParamsV1 $dpdServicesParamsV1 = null)
    {
        $this->dpdServicesParamsV1 = $dpdServicesParamsV1;
        return $this;
    }
    /**
     * Get outputDocFormatV1 value
     * @return string|null
     */
    public function getOutputDocFormatV1()
    {
        return $this->outputDocFormatV1;
    }
    /**
     * Set outputDocFormatV1 value
     * @uses \EnumType\OutputDocFormatDSPEnumV1::valueIsValid()
     * @uses \EnumType\OutputDocFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocFormatV1
     * @return \StructType\GenerateSpedLabelsV1
     */
    public function setOutputDocFormatV1($outputDocFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OutputDocFormatDSPEnumV1::valueIsValid($outputDocFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OutputDocFormatDSPEnumV1', is_array($outputDocFormatV1) ? implode(', ', $outputDocFormatV1) : var_export($outputDocFormatV1, true), implode(', ', \EnumType\OutputDocFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocFormatV1 = $outputDocFormatV1;
        return $this;
    }
    /**
     * Get outputDocPageFormatV1 value
     * @return string|null
     */
    public function getOutputDocPageFormatV1()
    {
        return $this->outputDocPageFormatV1;
    }
    /**
     * Set outputDocPageFormatV1 value
     * @uses \EnumType\OutputDocPageFormatDSPEnumV1::valueIsValid()
     * @uses \EnumType\OutputDocPageFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocPageFormatV1
     * @return \StructType\GenerateSpedLabelsV1
     */
    public function setOutputDocPageFormatV1($outputDocPageFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OutputDocPageFormatDSPEnumV1::valueIsValid($outputDocPageFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OutputDocPageFormatDSPEnumV1', is_array($outputDocPageFormatV1) ? implode(', ', $outputDocPageFormatV1) : var_export($outputDocPageFormatV1, true), implode(', ', \EnumType\OutputDocPageFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocPageFormatV1 = $outputDocPageFormatV1;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \StructType\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \StructType\AuthDataV1 $authDataV1
     * @return \StructType\GenerateSpedLabelsV1
     */
    public function setAuthDataV1(\StructType\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
