<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generatePackagesNumbersV5 StructType
 * Meta information extracted from the WSDL
 * - type: tns:generatePackagesNumbersV5
 * @subpackage Structs
 */
class GeneratePackagesNumbersV5 extends AbstractStructBase
{
    /**
     * The openUMLFeV4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpenUMLFeV4
     */
    public $openUMLFeV4;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The langCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generatePackagesNumbersV5
     * @uses GeneratePackagesNumbersV5::setOpenUMLFeV4()
     * @uses GeneratePackagesNumbersV5::setPkgNumsGenerationPolicyV1()
     * @uses GeneratePackagesNumbersV5::setLangCode()
     * @uses GeneratePackagesNumbersV5::setAuthDataV1()
     * @param \StructType\OpenUMLFeV4 $openUMLFeV4
     * @param string $pkgNumsGenerationPolicyV1
     * @param string $langCode
     * @param \StructType\AuthDataV1 $authDataV1
     */
    public function __construct(\StructType\OpenUMLFeV4 $openUMLFeV4 = null, $pkgNumsGenerationPolicyV1 = null, $langCode = null, \StructType\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLFeV4($openUMLFeV4)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setLangCode($langCode)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLFeV4 value
     * @return \StructType\OpenUMLFeV4|null
     */
    public function getOpenUMLFeV4()
    {
        return $this->openUMLFeV4;
    }
    /**
     * Set openUMLFeV4 value
     * @param \StructType\OpenUMLFeV4 $openUMLFeV4
     * @return \StructType\GeneratePackagesNumbersV5
     */
    public function setOpenUMLFeV4(\StructType\OpenUMLFeV4 $openUMLFeV4 = null)
    {
        $this->openUMLFeV4 = $openUMLFeV4;
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \EnumType\PkgNumsGenerationPolicyV1::valueIsValid()
     * @uses \EnumType\PkgNumsGenerationPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \StructType\GeneratePackagesNumbersV5
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PkgNumsGenerationPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PkgNumsGenerationPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \EnumType\PkgNumsGenerationPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \StructType\GeneratePackagesNumbersV5
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \StructType\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \StructType\AuthDataV1 $authDataV1
     * @return \StructType\GeneratePackagesNumbersV5
     */
    public function setAuthDataV1(\StructType\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
