<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentGenerationResponseV2 StructType
 * @subpackage Structs
 */
class DocumentGenerationResponseV2 extends AbstractStructBase
{
    /**
     * The DestinationDataList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DestinationDataList
     */
    public $DestinationDataList;
    /**
     * The DocumentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentData;
    /**
     * The nonMatchingDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NonMatchingData[]
     */
    public $nonMatchingDataList;
    /**
     * The Session
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SessionDGRV2
     */
    public $Session;
    /**
     * Constructor method for documentGenerationResponseV2
     * @uses DocumentGenerationResponseV2::setDestinationDataList()
     * @uses DocumentGenerationResponseV2::setDocumentData()
     * @uses DocumentGenerationResponseV2::setNonMatchingDataList()
     * @uses DocumentGenerationResponseV2::setSession()
     * @param \StructType\DestinationDataList $destinationDataList
     * @param string $documentData
     * @param \StructType\NonMatchingData[] $nonMatchingDataList
     * @param \StructType\SessionDGRV2 $session
     */
    public function __construct(\StructType\DestinationDataList $destinationDataList = null, $documentData = null, array $nonMatchingDataList = array(), \StructType\SessionDGRV2 $session = null)
    {
        $this
            ->setDestinationDataList($destinationDataList)
            ->setDocumentData($documentData)
            ->setNonMatchingDataList($nonMatchingDataList)
            ->setSession($session);
    }
    /**
     * Get DestinationDataList value
     * @return \StructType\DestinationDataList|null
     */
    public function getDestinationDataList()
    {
        return $this->DestinationDataList;
    }
    /**
     * Set DestinationDataList value
     * @param \StructType\DestinationDataList $destinationDataList
     * @return \StructType\DocumentGenerationResponseV2
     */
    public function setDestinationDataList(\StructType\DestinationDataList $destinationDataList = null)
    {
        $this->DestinationDataList = $destinationDataList;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param string $documentData
     * @return \StructType\DocumentGenerationResponseV2
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Get nonMatchingDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NonMatchingData[]|null
     */
    public function getNonMatchingDataList()
    {
        return isset($this->nonMatchingDataList) ? $this->nonMatchingDataList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNonMatchingDataList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNonMatchingDataList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNonMatchingDataListForArrayConstraintsFromSetNonMatchingDataList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentGenerationResponseV2NonMatchingDataListItem) {
            // validation for constraint: itemType
            if (!$documentGenerationResponseV2NonMatchingDataListItem instanceof \StructType\NonMatchingData) {
                $invalidValues[] = is_object($documentGenerationResponseV2NonMatchingDataListItem) ? get_class($documentGenerationResponseV2NonMatchingDataListItem) : sprintf('%s(%s)', gettype($documentGenerationResponseV2NonMatchingDataListItem), var_export($documentGenerationResponseV2NonMatchingDataListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nonMatchingDataList property can only contain items of type \StructType\NonMatchingData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nonMatchingDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NonMatchingData[] $nonMatchingDataList
     * @return \StructType\DocumentGenerationResponseV2
     */
    public function setNonMatchingDataList(array $nonMatchingDataList = array())
    {
        // validation for constraint: array
        if ('' !== ($nonMatchingDataListArrayErrorMessage = self::validateNonMatchingDataListForArrayConstraintsFromSetNonMatchingDataList($nonMatchingDataList))) {
            throw new \InvalidArgumentException($nonMatchingDataListArrayErrorMessage, __LINE__);
        }
        if (is_null($nonMatchingDataList) || (is_array($nonMatchingDataList) && empty($nonMatchingDataList))) {
            unset($this->nonMatchingDataList);
        } else {
            $this->nonMatchingDataList = $nonMatchingDataList;
        }
        return $this;
    }
    /**
     * Add item to nonMatchingDataList value
     * @throws \InvalidArgumentException
     * @param \StructType\NonMatchingData $item
     * @return \StructType\DocumentGenerationResponseV2
     */
    public function addToNonMatchingDataList(\StructType\NonMatchingData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NonMatchingData) {
            throw new \InvalidArgumentException(sprintf('The nonMatchingDataList property can only contain items of type \StructType\NonMatchingData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nonMatchingDataList[] = $item;
        return $this;
    }
    /**
     * Get Session value
     * @return \StructType\SessionDGRV2|null
     */
    public function getSession()
    {
        return $this->Session;
    }
    /**
     * Set Session value
     * @param \StructType\SessionDGRV2 $session
     * @return \StructType\DocumentGenerationResponseV2
     */
    public function setSession(\StructType\SessionDGRV2 $session = null)
    {
        $this->Session = $session;
        return $this;
    }
}
