<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationDataList StructType
 * @subpackage Structs
 */
class DestinationDataList extends AbstractStructBase
{
    /**
     * The DestinationsData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DestinationsData[]
     */
    public $DestinationsData;
    /**
     * Constructor method for DestinationDataList
     * @uses DestinationDataList::setDestinationsData()
     * @param \StructType\DestinationsData[] $destinationsData
     */
    public function __construct(array $destinationsData = array())
    {
        $this
            ->setDestinationsData($destinationsData);
    }
    /**
     * Get DestinationsData value
     * @return \StructType\DestinationsData[]|null
     */
    public function getDestinationsData()
    {
        return $this->DestinationsData;
    }
    /**
     * This method is responsible for validating the values passed to the setDestinationsData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDestinationsData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDestinationsDataForArrayConstraintsFromSetDestinationsData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $destinationDataListDestinationsDataItem) {
            // validation for constraint: itemType
            if (!$destinationDataListDestinationsDataItem instanceof \StructType\DestinationsData) {
                $invalidValues[] = is_object($destinationDataListDestinationsDataItem) ? get_class($destinationDataListDestinationsDataItem) : sprintf('%s(%s)', gettype($destinationDataListDestinationsDataItem), var_export($destinationDataListDestinationsDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DestinationsData property can only contain items of type \StructType\DestinationsData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DestinationsData value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationsData[] $destinationsData
     * @return \StructType\DestinationDataList
     */
    public function setDestinationsData(array $destinationsData = array())
    {
        // validation for constraint: array
        if ('' !== ($destinationsDataArrayErrorMessage = self::validateDestinationsDataForArrayConstraintsFromSetDestinationsData($destinationsData))) {
            throw new \InvalidArgumentException($destinationsDataArrayErrorMessage, __LINE__);
        }
        $this->DestinationsData = $destinationsData;
        return $this;
    }
    /**
     * Add item to DestinationsData value
     * @throws \InvalidArgumentException
     * @param \StructType\DestinationsData $item
     * @return \StructType\DestinationDataList
     */
    public function addToDestinationsData(\StructType\DestinationsData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DestinationsData) {
            throw new \InvalidArgumentException(sprintf('The DestinationsData property can only contain items of type \StructType\DestinationsData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DestinationsData[] = $item;
        return $this;
    }
}
