<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authDataV1 StructType
 * @subpackage Structs
 */
class AuthDataV1 extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The masterFid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $masterFid;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for authDataV1
     * @uses AuthDataV1::setLogin()
     * @uses AuthDataV1::setMasterFid()
     * @uses AuthDataV1::setPassword()
     * @param string $login
     * @param int $masterFid
     * @param string $password
     */
    public function __construct($login = null, $masterFid = null, $password = null)
    {
        $this
            ->setLogin($login)
            ->setMasterFid($masterFid)
            ->setPassword($password);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\AuthDataV1
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get masterFid value
     * @return int|null
     */
    public function getMasterFid()
    {
        return $this->masterFid;
    }
    /**
     * Set masterFid value
     * @param int $masterFid
     * @return \StructType\AuthDataV1
     */
    public function setMasterFid($masterFid = null)
    {
        // validation for constraint: int
        if (!is_null($masterFid) && !(is_int($masterFid) || ctype_digit($masterFid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($masterFid, true), gettype($masterFid)), __LINE__);
        }
        $this->masterFid = $masterFid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AuthDataV1
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
}
