<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Generate ServiceType
 * @subpackage Services
 */
class Generate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named generateProtocolV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateProtocolV1 $parameters
     * @return \StructType\GenerateProtocolV1Response|bool
     */
    public function generateProtocolV1(\StructType\GenerateProtocolV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateProtocolV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateProtocolV2 $parameters
     * @return \StructType\GenerateProtocolV2Response|bool
     */
    public function generateProtocolV2(\StructType\GenerateProtocolV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateShipmentV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateShipmentV1 $parameters
     * @return \StructType\GenerateShipmentV1Response|bool
     */
    public function generateShipmentV1(\StructType\GenerateShipmentV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateShipmentV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateDomesticReturnLabelV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateDomesticReturnLabelV1 $parameters
     * @return \StructType\GenerateDomesticReturnLabelV1Response|bool
     */
    public function generateDomesticReturnLabelV1(\StructType\GenerateDomesticReturnLabelV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateDomesticReturnLabelV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateSpedLabelsV1 $parameters
     * @return \StructType\GenerateSpedLabelsV1Response|bool
     */
    public function generateSpedLabelsV1(\StructType\GenerateSpedLabelsV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateSpedLabelsV4 $parameters
     * @return \StructType\GenerateSpedLabelsV4Response|bool
     */
    public function generateSpedLabelsV4(\StructType\GenerateSpedLabelsV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateSpedLabelsV3 $parameters
     * @return \StructType\GenerateSpedLabelsV3Response|bool
     */
    public function generateSpedLabelsV3(\StructType\GenerateSpedLabelsV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateReturnPackages
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateReturnPackages $parameters
     * @return \StructType\GenerateReturnPackagesResponse|bool
     */
    public function generateReturnPackages(\StructType\GenerateReturnPackages $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateReturnPackages($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateSpedLabelsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateSpedLabelsV2 $parameters
     * @return \StructType\GenerateSpedLabelsV2Response|bool
     */
    public function generateSpedLabelsV2(\StructType\GenerateSpedLabelsV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateSpedLabelsV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV6
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV6 $parameters
     * @return \StructType\GeneratePackagesNumbersV6Response|bool
     */
    public function generatePackagesNumbersV6(\StructType\GeneratePackagesNumbersV6 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV6($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV7
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV7 $parameters
     * @return \StructType\GeneratePackagesNumbersV7Response|bool
     */
    public function generatePackagesNumbersV7(\StructType\GeneratePackagesNumbersV7 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV7($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV8
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV8 $parameters
     * @return \StructType\GeneratePackagesNumbersV8Response|bool
     */
    public function generatePackagesNumbersV8(\StructType\GeneratePackagesNumbersV8 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV8($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV9
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV9 $parameters
     * @return \StructType\GeneratePackagesNumbersV9Response|bool
     */
    public function generatePackagesNumbersV9(\StructType\GeneratePackagesNumbersV9 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV9($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateInternationalPackageNumbersV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateInternationalPackageNumbersV1 $parameters
     * @return \StructType\GenerateInternationalPackageNumbersV1Response|bool
     */
    public function generateInternationalPackageNumbersV1(\StructType\GenerateInternationalPackageNumbersV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateInternationalPackageNumbersV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV1 $parameters
     * @return \StructType\GeneratePackagesNumbersV1Response|bool
     */
    public function generatePackagesNumbersV1(\StructType\GeneratePackagesNumbersV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV2 $parameters
     * @return \StructType\GeneratePackagesNumbersV2Response|bool
     */
    public function generatePackagesNumbersV2(\StructType\GeneratePackagesNumbersV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV3 $parameters
     * @return \StructType\GeneratePackagesNumbersV3Response|bool
     */
    public function generatePackagesNumbersV3(\StructType\GeneratePackagesNumbersV3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV4
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV4 $parameters
     * @return \StructType\GeneratePackagesNumbersV4Response|bool
     */
    public function generatePackagesNumbersV4(\StructType\GeneratePackagesNumbersV4 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV4($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generatePackagesNumbersV5
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GeneratePackagesNumbersV5 $parameters
     * @return \StructType\GeneratePackagesNumbersV5Response|bool
     */
    public function generatePackagesNumbersV5(\StructType\GeneratePackagesNumbersV5 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generatePackagesNumbersV5($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named generateReturnLabelV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateReturnLabelV1 $parameters
     * @return \StructType\GenerateReturnLabelV1Response|bool
     */
    public function generateReturnLabelV1(\StructType\GenerateReturnLabelV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateReturnLabelV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateProtocolsWithDestinationsV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateProtocolsWithDestinationsV1 $parameters
     * @return \StructType\GenerateProtocolsWithDestinationsV1Response|bool
     */
    public function generateProtocolsWithDestinationsV1(\StructType\GenerateProtocolsWithDestinationsV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolsWithDestinationsV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * generateProtocolsWithDestinationsV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GenerateProtocolsWithDestinationsV2 $parameters
     * @return \StructType\GenerateProtocolsWithDestinationsV2Response|bool
     */
    public function generateProtocolsWithDestinationsV2(\StructType\GenerateProtocolsWithDestinationsV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->generateProtocolsWithDestinationsV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GenerateDomesticReturnLabelV1Response|\StructType\GenerateInternationalPackageNumbersV1Response|\StructType\GeneratePackagesNumbersV1Response|\StructType\GeneratePackagesNumbersV2Response|\StructType\GeneratePackagesNumbersV3Response|\StructType\GeneratePackagesNumbersV4Response|\StructType\GeneratePackagesNumbersV5Response|\StructType\GeneratePackagesNumbersV6Response|\StructType\GeneratePackagesNumbersV7Response|\StructType\GeneratePackagesNumbersV8Response|\StructType\GeneratePackagesNumbersV9Response|\StructType\GenerateProtocolsWithDestinationsV1Response|\StructType\GenerateProtocolsWithDestinationsV2Response|\StructType\GenerateProtocolV1Response|\StructType\GenerateProtocolV2Response|\StructType\GenerateReturnLabelV1Response|\StructType\GenerateReturnPackagesResponse|\StructType\GenerateShipmentV1Response|\StructType\GenerateSpedLabelsV1Response|\StructType\GenerateSpedLabelsV2Response|\StructType\GenerateSpedLabelsV3Response|\StructType\GenerateSpedLabelsV4Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
