<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findPostalCodeV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindPostalCodeV1 $parameters
     * @return \StructType\FindPostalCodeV1Response|bool
     */
    public function findPostalCodeV1(\StructType\FindPostalCodeV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findPostalCodeV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindPostalCodeV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
