<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for statusInfoPCRV1 StructType
 * @subpackage Structs
 */
class StatusInfoPCRV1 extends AbstractStructBase
{
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for statusInfoPCRV1
     * @uses StatusInfoPCRV1::setDescription()
     * @uses StatusInfoPCRV1::setStatus()
     * @param string $description
     * @param string $status
     */
    public function __construct($description = null, $status = null)
    {
        $this
            ->setDescription($description)
            ->setStatus($status);
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\StatusInfoPCRV1
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\StatusPCREnumV1::valueIsValid()
     * @uses \EnumType\StatusPCREnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\StatusInfoPCRV1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusPCREnumV1::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusPCREnumV1', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\StatusPCREnumV1::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
