<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionPGRV2 StructType
 * @subpackage Structs
 */
class SessionPGRV2 extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SessionId;
    /**
     * The BeginTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BeginTime;
    /**
     * The EndTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * The Packages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Packages
     */
    public $Packages;
    /**
     * Constructor method for sessionPGRV2
     * @uses SessionPGRV2::setStatus()
     * @uses SessionPGRV2::setSessionId()
     * @uses SessionPGRV2::setBeginTime()
     * @uses SessionPGRV2::setEndTime()
     * @uses SessionPGRV2::setPackages()
     * @param string $status
     * @param int $sessionId
     * @param string $beginTime
     * @param string $endTime
     * @param \StructType\Packages $packages
     */
    public function __construct($status = null, $sessionId = null, $beginTime = null, $endTime = null, \StructType\Packages $packages = null)
    {
        $this
            ->setStatus($status)
            ->setSessionId($sessionId)
            ->setBeginTime($beginTime)
            ->setEndTime($endTime)
            ->setPackages($packages);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SessionPGRV2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get SessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param int $sessionId
     * @return \StructType\SessionPGRV2
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !(is_int($sessionId) || ctype_digit($sessionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get BeginTime value
     * @return string|null
     */
    public function getBeginTime()
    {
        return $this->BeginTime;
    }
    /**
     * Set BeginTime value
     * @param string $beginTime
     * @return \StructType\SessionPGRV2
     */
    public function setBeginTime($beginTime = null)
    {
        // validation for constraint: string
        if (!is_null($beginTime) && !is_string($beginTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginTime, true), gettype($beginTime)), __LINE__);
        }
        $this->BeginTime = $beginTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\SessionPGRV2
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get Packages value
     * @return \StructType\Packages|null
     */
    public function getPackages()
    {
        return $this->Packages;
    }
    /**
     * Set Packages value
     * @param \StructType\Packages $packages
     * @return \StructType\SessionPGRV2
     */
    public function setPackages(\StructType\Packages $packages = null)
    {
        $this->Packages = $packages;
        return $this;
    }
}
