<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sessionPGRV1 StructType
 * @subpackage Structs
 */
class SessionPGRV1 extends AbstractStructBase
{
    /**
     * The beginTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $beginTime;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endTime;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PackagePGRV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for sessionPGRV1
     * @uses SessionPGRV1::setBeginTime()
     * @uses SessionPGRV1::setEndTime()
     * @uses SessionPGRV1::setPackages()
     * @uses SessionPGRV1::setSessionId()
     * @uses SessionPGRV1::setStatus()
     * @param string $beginTime
     * @param string $endTime
     * @param \StructType\PackagePGRV1[] $packages
     * @param int $sessionId
     * @param string $status
     */
    public function __construct($beginTime = null, $endTime = null, array $packages = array(), $sessionId = null, $status = null)
    {
        $this
            ->setBeginTime($beginTime)
            ->setEndTime($endTime)
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setStatus($status);
    }
    /**
     * Get beginTime value
     * @return string|null
     */
    public function getBeginTime()
    {
        return $this->beginTime;
    }
    /**
     * Set beginTime value
     * @param string $beginTime
     * @return \StructType\SessionPGRV1
     */
    public function setBeginTime($beginTime = null)
    {
        // validation for constraint: string
        if (!is_null($beginTime) && !is_string($beginTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginTime, true), gettype($beginTime)), __LINE__);
        }
        $this->beginTime = $beginTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \StructType\SessionPGRV1
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PackagePGRV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sessionPGRV1PackagesItem) {
            // validation for constraint: itemType
            if (!$sessionPGRV1PackagesItem instanceof \StructType\PackagePGRV1) {
                $invalidValues[] = is_object($sessionPGRV1PackagesItem) ? get_class($sessionPGRV1PackagesItem) : sprintf('%s(%s)', gettype($sessionPGRV1PackagesItem), var_export($sessionPGRV1PackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \StructType\PackagePGRV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackagePGRV1[] $packages
     * @return \StructType\SessionPGRV1
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \StructType\PackagePGRV1 $item
     * @return \StructType\SessionPGRV1
     */
    public function addToPackages(\StructType\PackagePGRV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackagePGRV1) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \StructType\PackagePGRV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \StructType\SessionPGRV1
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !(is_int($sessionId) || ctype_digit($sessionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ValidationStatusPGREnumV1::valueIsValid()
     * @uses \EnumType\ValidationStatusPGREnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SessionPGRV1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidationStatusPGREnumV1::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ValidationStatusPGREnumV1', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ValidationStatusPGREnumV1::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
