<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceCODDedicatedAccountOpenUMLFeV1 StructType
 * @subpackage Structs
 */
class ServiceCODDedicatedAccountOpenUMLFeV1 extends AbstractStructBase
{
    /**
     * The accountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accountNumber;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amount;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * Constructor method for serviceCODDedicatedAccountOpenUMLFeV1
     * @uses ServiceCODDedicatedAccountOpenUMLFeV1::setAccountNumber()
     * @uses ServiceCODDedicatedAccountOpenUMLFeV1::setAmount()
     * @uses ServiceCODDedicatedAccountOpenUMLFeV1::setCurrency()
     * @param string $accountNumber
     * @param string $amount
     * @param string $currency
     */
    public function __construct($accountNumber = null, $amount = null, $currency = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAmount($amount)
            ->setCurrency($currency);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\ServiceCODDedicatedAccountOpenUMLFeV1
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \StructType\ServiceCODDedicatedAccountOpenUMLFeV1
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: string
        if (!is_null($amount) && !is_string($amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @uses \EnumType\ServiceCurrencyEnum::valueIsValid()
     * @uses \EnumType\ServiceCurrencyEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currency
     * @return \StructType\ServiceCODDedicatedAccountOpenUMLFeV1
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceCurrencyEnum::valueIsValid($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ServiceCurrencyEnum', is_array($currency) ? implode(', ', $currency) : var_export($currency, true), implode(', ', \EnumType\ServiceCurrencyEnum::getValidValues())), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
}
