<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for returnedWaybillsV1 StructType
 * @subpackage Structs
 */
class ReturnedWaybillsV1 extends AbstractStructBase
{
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $waybill;
    /**
     * Constructor method for returnedWaybillsV1
     * @uses ReturnedWaybillsV1::setWaybill()
     * @param string[] $waybill
     */
    public function __construct(array $waybill = array())
    {
        $this
            ->setWaybill($waybill);
    }
    /**
     * Get waybill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getWaybill()
    {
        return isset($this->waybill) ? $this->waybill : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWaybill method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWaybill method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWaybillForArrayConstraintsFromSetWaybill(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $returnedWaybillsV1WaybillItem) {
            // validation for constraint: itemType
            if (!is_string($returnedWaybillsV1WaybillItem)) {
                $invalidValues[] = is_object($returnedWaybillsV1WaybillItem) ? get_class($returnedWaybillsV1WaybillItem) : sprintf('%s(%s)', gettype($returnedWaybillsV1WaybillItem), var_export($returnedWaybillsV1WaybillItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The waybill property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set waybill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $waybill
     * @return \StructType\ReturnedWaybillsV1
     */
    public function setWaybill(array $waybill = array())
    {
        // validation for constraint: array
        if ('' !== ($waybillArrayErrorMessage = self::validateWaybillForArrayConstraintsFromSetWaybill($waybill))) {
            throw new \InvalidArgumentException($waybillArrayErrorMessage, __LINE__);
        }
        if (is_null($waybill) || (is_array($waybill) && empty($waybill))) {
            unset($this->waybill);
        } else {
            $this->waybill = $waybill;
        }
        return $this;
    }
    /**
     * Add item to waybill value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ReturnedWaybillsV1
     */
    public function addToWaybill($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The waybill property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->waybill[] = $item;
        return $this;
    }
}
