<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelDGRV2 StructType
 * @subpackage Structs
 */
class ParcelDGRV2 extends AbstractStructBase
{
    /**
     * The parcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $parcelId;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusInfoDGRV2
     */
    public $statusInfo;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for parcelDGRV2
     * @uses ParcelDGRV2::setParcelId()
     * @uses ParcelDGRV2::setReference()
     * @uses ParcelDGRV2::setStatusInfo()
     * @uses ParcelDGRV2::setWaybill()
     * @param int $parcelId
     * @param string $reference
     * @param \StructType\StatusInfoDGRV2 $statusInfo
     * @param string $waybill
     */
    public function __construct($parcelId = null, $reference = null, \StructType\StatusInfoDGRV2 $statusInfo = null, $waybill = null)
    {
        $this
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setStatusInfo($statusInfo)
            ->setWaybill($waybill);
    }
    /**
     * Get parcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->parcelId;
    }
    /**
     * Set parcelId value
     * @param int $parcelId
     * @return \StructType\ParcelDGRV2
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        $this->parcelId = $parcelId;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ParcelDGRV2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \StructType\StatusInfoDGRV2|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \StructType\StatusInfoDGRV2 $statusInfo
     * @return \StructType\ParcelDGRV2
     */
    public function setStatusInfo(\StructType\StatusInfoDGRV2 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \StructType\ParcelDGRV2
     */
    public function setWaybill($waybill = null)
    {
        // validation for constraint: string
        if (!is_null($waybill) && !is_string($waybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybill, true), gettype($waybill)), __LINE__);
        }
        $this->waybill = $waybill;
        return $this;
    }
}
