<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageOpenUMLFeV10 StructType
 * @subpackage Structs
 */
class PackageOpenUMLFeV10 extends AbstractStructBase
{
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelOpenUMLFeV4[]
     */
    public $parcels;
    /**
     * The payerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerType;
    /**
     * The receiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageAddressOpenUMLFeV1
     */
    public $receiver;
    /**
     * The ref1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ref1;
    /**
     * The ref2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ref2;
    /**
     * The ref3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ref3;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The sender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PackageAddressOpenUMLFeV1
     */
    public $sender;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServicesOpenUMLFeV9
     */
    public $services;
    /**
     * The thirdPartyFID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $thirdPartyFID;
    /**
     * Constructor method for packageOpenUMLFeV10
     * @uses PackageOpenUMLFeV10::setParcels()
     * @uses PackageOpenUMLFeV10::setPayerType()
     * @uses PackageOpenUMLFeV10::setReceiver()
     * @uses PackageOpenUMLFeV10::setRef1()
     * @uses PackageOpenUMLFeV10::setRef2()
     * @uses PackageOpenUMLFeV10::setRef3()
     * @uses PackageOpenUMLFeV10::setReference()
     * @uses PackageOpenUMLFeV10::setSender()
     * @uses PackageOpenUMLFeV10::setServices()
     * @uses PackageOpenUMLFeV10::setThirdPartyFID()
     * @param \StructType\ParcelOpenUMLFeV4[] $parcels
     * @param string $payerType
     * @param \StructType\PackageAddressOpenUMLFeV1 $receiver
     * @param string $ref1
     * @param string $ref2
     * @param string $ref3
     * @param string $reference
     * @param \StructType\PackageAddressOpenUMLFeV1 $sender
     * @param \StructType\ServicesOpenUMLFeV9 $services
     * @param int $thirdPartyFID
     */
    public function __construct(array $parcels = array(), $payerType = null, \StructType\PackageAddressOpenUMLFeV1 $receiver = null, $ref1 = null, $ref2 = null, $ref3 = null, $reference = null, \StructType\PackageAddressOpenUMLFeV1 $sender = null, \StructType\ServicesOpenUMLFeV9 $services = null, $thirdPartyFID = null)
    {
        $this
            ->setParcels($parcels)
            ->setPayerType($payerType)
            ->setReceiver($receiver)
            ->setRef1($ref1)
            ->setRef2($ref2)
            ->setRef3($ref3)
            ->setReference($reference)
            ->setSender($sender)
            ->setServices($services)
            ->setThirdPartyFID($thirdPartyFID);
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelOpenUMLFeV4[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageOpenUMLFeV10ParcelsItem) {
            // validation for constraint: itemType
            if (!$packageOpenUMLFeV10ParcelsItem instanceof \StructType\ParcelOpenUMLFeV4) {
                $invalidValues[] = is_object($packageOpenUMLFeV10ParcelsItem) ? get_class($packageOpenUMLFeV10ParcelsItem) : sprintf('%s(%s)', gettype($packageOpenUMLFeV10ParcelsItem), var_export($packageOpenUMLFeV10ParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \StructType\ParcelOpenUMLFeV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelOpenUMLFeV4[] $parcels
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelOpenUMLFeV4 $item
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function addToParcels(\StructType\ParcelOpenUMLFeV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelOpenUMLFeV4) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \StructType\ParcelOpenUMLFeV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get payerType value
     * @return string|null
     */
    public function getPayerType()
    {
        return $this->payerType;
    }
    /**
     * Set payerType value
     * @uses \EnumType\PayerTypeEnumOpenUMLFeV1::valueIsValid()
     * @uses \EnumType\PayerTypeEnumOpenUMLFeV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payerType
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setPayerType($payerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PayerTypeEnumOpenUMLFeV1::valueIsValid($payerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PayerTypeEnumOpenUMLFeV1', is_array($payerType) ? implode(', ', $payerType) : var_export($payerType, true), implode(', ', \EnumType\PayerTypeEnumOpenUMLFeV1::getValidValues())), __LINE__);
        }
        $this->payerType = $payerType;
        return $this;
    }
    /**
     * Get receiver value
     * @return \StructType\PackageAddressOpenUMLFeV1|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \StructType\PackageAddressOpenUMLFeV1 $receiver
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setReceiver(\StructType\PackageAddressOpenUMLFeV1 $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get ref1 value
     * @return string|null
     */
    public function getRef1()
    {
        return $this->ref1;
    }
    /**
     * Set ref1 value
     * @param string $ref1
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setRef1($ref1 = null)
    {
        // validation for constraint: string
        if (!is_null($ref1) && !is_string($ref1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref1, true), gettype($ref1)), __LINE__);
        }
        $this->ref1 = $ref1;
        return $this;
    }
    /**
     * Get ref2 value
     * @return string|null
     */
    public function getRef2()
    {
        return $this->ref2;
    }
    /**
     * Set ref2 value
     * @param string $ref2
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setRef2($ref2 = null)
    {
        // validation for constraint: string
        if (!is_null($ref2) && !is_string($ref2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref2, true), gettype($ref2)), __LINE__);
        }
        $this->ref2 = $ref2;
        return $this;
    }
    /**
     * Get ref3 value
     * @return string|null
     */
    public function getRef3()
    {
        return $this->ref3;
    }
    /**
     * Set ref3 value
     * @param string $ref3
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setRef3($ref3 = null)
    {
        // validation for constraint: string
        if (!is_null($ref3) && !is_string($ref3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref3, true), gettype($ref3)), __LINE__);
        }
        $this->ref3 = $ref3;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get sender value
     * @return \StructType\PackageAddressOpenUMLFeV1|null
     */
    public function getSender()
    {
        return $this->sender;
    }
    /**
     * Set sender value
     * @param \StructType\PackageAddressOpenUMLFeV1 $sender
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setSender(\StructType\PackageAddressOpenUMLFeV1 $sender = null)
    {
        $this->sender = $sender;
        return $this;
    }
    /**
     * Get services value
     * @return \StructType\ServicesOpenUMLFeV9|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \StructType\ServicesOpenUMLFeV9 $services
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setServices(\StructType\ServicesOpenUMLFeV9 $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get thirdPartyFID value
     * @return int|null
     */
    public function getThirdPartyFID()
    {
        return $this->thirdPartyFID;
    }
    /**
     * Set thirdPartyFID value
     * @param int $thirdPartyFID
     * @return \StructType\PackageOpenUMLFeV10
     */
    public function setThirdPartyFID($thirdPartyFID = null)
    {
        // validation for constraint: int
        if (!is_null($thirdPartyFID) && !(is_int($thirdPartyFID) || ctype_digit($thirdPartyFID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thirdPartyFID, true), gettype($thirdPartyFID)), __LINE__);
        }
        $this->thirdPartyFID = $thirdPartyFID;
        return $this;
    }
}
