<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for invalidFieldPGRV1 StructType
 * @subpackage Structs
 */
class InvalidFieldPGRV1 extends AbstractStructBase
{
    /**
     * The fieldName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fieldName;
    /**
     * The info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $info;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for invalidFieldPGRV1
     * @uses InvalidFieldPGRV1::setFieldName()
     * @uses InvalidFieldPGRV1::setInfo()
     * @uses InvalidFieldPGRV1::setStatus()
     * @param string $fieldName
     * @param string $info
     * @param string $status
     */
    public function __construct($fieldName = null, $info = null, $status = null)
    {
        $this
            ->setFieldName($fieldName)
            ->setInfo($info)
            ->setStatus($status);
    }
    /**
     * Get fieldName value
     * @return string|null
     */
    public function getFieldName()
    {
        return $this->fieldName;
    }
    /**
     * Set fieldName value
     * @param string $fieldName
     * @return \StructType\InvalidFieldPGRV1
     */
    public function setFieldName($fieldName = null)
    {
        // validation for constraint: string
        if (!is_null($fieldName) && !is_string($fieldName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldName, true), gettype($fieldName)), __LINE__);
        }
        $this->fieldName = $fieldName;
        return $this;
    }
    /**
     * Get info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \StructType\InvalidFieldPGRV1
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\FieldValidationStatusPGREnumV1::valueIsValid()
     * @uses \EnumType\FieldValidationStatusPGREnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\InvalidFieldPGRV1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FieldValidationStatusPGREnumV1::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FieldValidationStatusPGREnumV1', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\FieldValidationStatusPGREnumV1::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
