<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdServicesParamsV1 StructType
 * @subpackage Structs
 */
class DpdServicesParamsV1 extends AbstractStructBase
{
    /**
     * The documentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentId;
    /**
     * The pickupAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PickupAddressDSPV1
     */
    public $pickupAddress;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policy;
    /**
     * The session
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SessionDSPV1
     */
    public $session;
    /**
     * Constructor method for dpdServicesParamsV1
     * @uses DpdServicesParamsV1::setDocumentId()
     * @uses DpdServicesParamsV1::setPickupAddress()
     * @uses DpdServicesParamsV1::setPolicy()
     * @uses DpdServicesParamsV1::setSession()
     * @param string $documentId
     * @param \StructType\PickupAddressDSPV1 $pickupAddress
     * @param string $policy
     * @param \StructType\SessionDSPV1 $session
     */
    public function __construct($documentId = null, \StructType\PickupAddressDSPV1 $pickupAddress = null, $policy = null, \StructType\SessionDSPV1 $session = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setPickupAddress($pickupAddress)
            ->setPolicy($policy)
            ->setSession($session);
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \StructType\DpdServicesParamsV1
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get pickupAddress value
     * @return \StructType\PickupAddressDSPV1|null
     */
    public function getPickupAddress()
    {
        return $this->pickupAddress;
    }
    /**
     * Set pickupAddress value
     * @param \StructType\PickupAddressDSPV1 $pickupAddress
     * @return \StructType\DpdServicesParamsV1
     */
    public function setPickupAddress(\StructType\PickupAddressDSPV1 $pickupAddress = null)
    {
        $this->pickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get policy value
     * @return string|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @uses \EnumType\PolicyDSPEnumV1::valueIsValid()
     * @uses \EnumType\PolicyDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policy
     * @return \StructType\DpdServicesParamsV1
     */
    public function setPolicy($policy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyDSPEnumV1::valueIsValid($policy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyDSPEnumV1', is_array($policy) ? implode(', ', $policy) : var_export($policy, true), implode(', ', \EnumType\PolicyDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get session value
     * @return \StructType\SessionDSPV1|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param \StructType\SessionDSPV1 $session
     * @return \StructType\DpdServicesParamsV1
     */
    public function setSession(\StructType\SessionDSPV1 $session = null)
    {
        $this->session = $session;
        return $this;
    }
}
