<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdPickupCallParamsV2 StructType
 * @subpackage Structs
 */
class DpdPickupCallParamsV2 extends AbstractStructBase
{
    /**
     * The operationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $operationType;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The orderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderType;
    /**
     * The pickupCallSimplifiedDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PickupCallSimplifiedDetailsDPPV1
     */
    public $pickupCallSimplifiedDetails;
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The updateMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updateMode;
    /**
     * The waybillsReady
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $waybillsReady;
    /**
     * Constructor method for dpdPickupCallParamsV2
     * @uses DpdPickupCallParamsV2::setOperationType()
     * @uses DpdPickupCallParamsV2::setOrderNumber()
     * @uses DpdPickupCallParamsV2::setOrderType()
     * @uses DpdPickupCallParamsV2::setPickupCallSimplifiedDetails()
     * @uses DpdPickupCallParamsV2::setPickupDate()
     * @uses DpdPickupCallParamsV2::setPickupTimeFrom()
     * @uses DpdPickupCallParamsV2::setPickupTimeTo()
     * @uses DpdPickupCallParamsV2::setUpdateMode()
     * @uses DpdPickupCallParamsV2::setWaybillsReady()
     * @param string $operationType
     * @param string $orderNumber
     * @param string $orderType
     * @param \StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails
     * @param string $pickupDate
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $updateMode
     * @param bool $waybillsReady
     */
    public function __construct($operationType = null, $orderNumber = null, $orderType = null, \StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails = null, $pickupDate = null, $pickupTimeFrom = null, $pickupTimeTo = null, $updateMode = null, $waybillsReady = null)
    {
        $this
            ->setOperationType($operationType)
            ->setOrderNumber($orderNumber)
            ->setOrderType($orderType)
            ->setPickupCallSimplifiedDetails($pickupCallSimplifiedDetails)
            ->setPickupDate($pickupDate)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setUpdateMode($updateMode)
            ->setWaybillsReady($waybillsReady);
    }
    /**
     * Get operationType value
     * @return string|null
     */
    public function getOperationType()
    {
        return $this->operationType;
    }
    /**
     * Set operationType value
     * @uses \EnumType\PickupCallOperationTypeDPPEnumV1::valueIsValid()
     * @uses \EnumType\PickupCallOperationTypeDPPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operationType
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PickupCallOperationTypeDPPEnumV1::valueIsValid($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PickupCallOperationTypeDPPEnumV1', is_array($operationType) ? implode(', ', $operationType) : var_export($operationType, true), implode(', ', \EnumType\PickupCallOperationTypeDPPEnumV1::getValidValues())), __LINE__);
        }
        $this->operationType = $operationType;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get orderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->orderType;
    }
    /**
     * Set orderType value
     * @uses \EnumType\PickupCallOrderTypeDPPEnumV1::valueIsValid()
     * @uses \EnumType\PickupCallOrderTypeDPPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PickupCallOrderTypeDPPEnumV1::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PickupCallOrderTypeDPPEnumV1', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \EnumType\PickupCallOrderTypeDPPEnumV1::getValidValues())), __LINE__);
        }
        $this->orderType = $orderType;
        return $this;
    }
    /**
     * Get pickupCallSimplifiedDetails value
     * @return \StructType\PickupCallSimplifiedDetailsDPPV1|null
     */
    public function getPickupCallSimplifiedDetails()
    {
        return $this->pickupCallSimplifiedDetails;
    }
    /**
     * Set pickupCallSimplifiedDetails value
     * @param \StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setPickupCallSimplifiedDetails(\StructType\PickupCallSimplifiedDetailsDPPV1 $pickupCallSimplifiedDetails = null)
    {
        $this->pickupCallSimplifiedDetails = $pickupCallSimplifiedDetails;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string|null
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeFrom) && !is_string($pickupTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeFrom, true), gettype($pickupTimeFrom)), __LINE__);
        }
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string|null
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeTo) && !is_string($pickupTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeTo, true), gettype($pickupTimeTo)), __LINE__);
        }
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get updateMode value
     * @return string|null
     */
    public function getUpdateMode()
    {
        return $this->updateMode;
    }
    /**
     * Set updateMode value
     * @uses \EnumType\PickupCallUpdateModeDPPEnumV1::valueIsValid()
     * @uses \EnumType\PickupCallUpdateModeDPPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $updateMode
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setUpdateMode($updateMode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PickupCallUpdateModeDPPEnumV1::valueIsValid($updateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PickupCallUpdateModeDPPEnumV1', is_array($updateMode) ? implode(', ', $updateMode) : var_export($updateMode, true), implode(', ', \EnumType\PickupCallUpdateModeDPPEnumV1::getValidValues())), __LINE__);
        }
        $this->updateMode = $updateMode;
        return $this;
    }
    /**
     * Get waybillsReady value
     * @return bool|null
     */
    public function getWaybillsReady()
    {
        return $this->waybillsReady;
    }
    /**
     * Set waybillsReady value
     * @param bool $waybillsReady
     * @return \StructType\DpdPickupCallParamsV2
     */
    public function setWaybillsReady($waybillsReady = null)
    {
        // validation for constraint: boolean
        if (!is_null($waybillsReady) && !is_bool($waybillsReady)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($waybillsReady, true), gettype($waybillsReady)), __LINE__);
        }
        $this->waybillsReady = $waybillsReady;
        return $this;
    }
}
