<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepotList StructType
 * @subpackage Structs
 */
class DepotList extends AbstractStructBase
{
    /**
     * The ProtocolDepot
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProtocolDepot[]
     */
    public $ProtocolDepot;
    /**
     * Constructor method for DepotList
     * @uses DepotList::setProtocolDepot()
     * @param \StructType\ProtocolDepot[] $protocolDepot
     */
    public function __construct(array $protocolDepot = array())
    {
        $this
            ->setProtocolDepot($protocolDepot);
    }
    /**
     * Get ProtocolDepot value
     * @return \StructType\ProtocolDepot[]|null
     */
    public function getProtocolDepot()
    {
        return $this->ProtocolDepot;
    }
    /**
     * This method is responsible for validating the values passed to the setProtocolDepot method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProtocolDepot method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProtocolDepotForArrayConstraintsFromSetProtocolDepot(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $depotListProtocolDepotItem) {
            // validation for constraint: itemType
            if (!$depotListProtocolDepotItem instanceof \StructType\ProtocolDepot) {
                $invalidValues[] = is_object($depotListProtocolDepotItem) ? get_class($depotListProtocolDepotItem) : sprintf('%s(%s)', gettype($depotListProtocolDepotItem), var_export($depotListProtocolDepotItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProtocolDepot property can only contain items of type \StructType\ProtocolDepot, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProtocolDepot value
     * @throws \InvalidArgumentException
     * @param \StructType\ProtocolDepot[] $protocolDepot
     * @return \StructType\DepotList
     */
    public function setProtocolDepot(array $protocolDepot = array())
    {
        // validation for constraint: array
        if ('' !== ($protocolDepotArrayErrorMessage = self::validateProtocolDepotForArrayConstraintsFromSetProtocolDepot($protocolDepot))) {
            throw new \InvalidArgumentException($protocolDepotArrayErrorMessage, __LINE__);
        }
        $this->ProtocolDepot = $protocolDepot;
        return $this;
    }
    /**
     * Add item to ProtocolDepot value
     * @throws \InvalidArgumentException
     * @param \StructType\ProtocolDepot $item
     * @return \StructType\DepotList
     */
    public function addToProtocolDepot(\StructType\ProtocolDepot $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProtocolDepot) {
            throw new \InvalidArgumentException(sprintf('The ProtocolDepot property can only contain items of type \StructType\ProtocolDepot, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProtocolDepot[] = $item;
        return $this;
    }
}
