<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for generateProtocolV1 operation/method
 */
if ($generate->generateProtocolV1(new \StructType\GenerateProtocolV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateProtocolV2 operation/method
 */
if ($generate->generateProtocolV2(new \StructType\GenerateProtocolV2()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateShipmentV1 operation/method
 */
if ($generate->generateShipmentV1(new \StructType\GenerateShipmentV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateDomesticReturnLabelV1 operation/method
 */
if ($generate->generateDomesticReturnLabelV1(new \StructType\GenerateDomesticReturnLabelV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateSpedLabelsV1 operation/method
 */
if ($generate->generateSpedLabelsV1(new \StructType\GenerateSpedLabelsV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateSpedLabelsV4 operation/method
 */
if ($generate->generateSpedLabelsV4(new \StructType\GenerateSpedLabelsV4()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateSpedLabelsV3 operation/method
 */
if ($generate->generateSpedLabelsV3(new \StructType\GenerateSpedLabelsV3()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateReturnPackages operation/method
 */
if ($generate->generateReturnPackages(new \StructType\GenerateReturnPackages()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateSpedLabelsV2 operation/method
 */
if ($generate->generateSpedLabelsV2(new \StructType\GenerateSpedLabelsV2()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV6 operation/method
 */
if ($generate->generatePackagesNumbersV6(new \StructType\GeneratePackagesNumbersV6()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV7 operation/method
 */
if ($generate->generatePackagesNumbersV7(new \StructType\GeneratePackagesNumbersV7()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV8 operation/method
 */
if ($generate->generatePackagesNumbersV8(new \StructType\GeneratePackagesNumbersV8()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV9 operation/method
 */
if ($generate->generatePackagesNumbersV9(new \StructType\GeneratePackagesNumbersV9()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateInternationalPackageNumbersV1 operation/method
 */
if ($generate->generateInternationalPackageNumbersV1(new \StructType\GenerateInternationalPackageNumbersV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV1 operation/method
 */
if ($generate->generatePackagesNumbersV1(new \StructType\GeneratePackagesNumbersV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV2 operation/method
 */
if ($generate->generatePackagesNumbersV2(new \StructType\GeneratePackagesNumbersV2()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV3 operation/method
 */
if ($generate->generatePackagesNumbersV3(new \StructType\GeneratePackagesNumbersV3()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV4 operation/method
 */
if ($generate->generatePackagesNumbersV4(new \StructType\GeneratePackagesNumbersV4()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generatePackagesNumbersV5 operation/method
 */
if ($generate->generatePackagesNumbersV5(new \StructType\GeneratePackagesNumbersV5()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateReturnLabelV1 operation/method
 */
if ($generate->generateReturnLabelV1(new \StructType\GenerateReturnLabelV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateProtocolsWithDestinationsV1 operation/method
 */
if ($generate->generateProtocolsWithDestinationsV1(new \StructType\GenerateProtocolsWithDestinationsV1()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Sample call for generateProtocolsWithDestinationsV2 operation/method
 */
if ($generate->generateProtocolsWithDestinationsV2(new \StructType\GenerateProtocolsWithDestinationsV2()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for findPostalCodeV1 operation/method
 */
if ($find->findPostalCodeV1(new \StructType\FindPostalCodeV1()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Samples for Packages ServiceType
 */
$packages = new \ServiceType\Packages($options);
/**
 * Sample call for packagesPickupCallV3 operation/method
 */
if ($packages->packagesPickupCallV3(new \StructType\PackagesPickupCallV3()) !== false) {
    print_r($packages->getResult());
} else {
    print_r($packages->getLastError());
}
/**
 * Sample call for packagesPickupCallV4 operation/method
 */
if ($packages->packagesPickupCallV4(new \StructType\PackagesPickupCallV4()) !== false) {
    print_r($packages->getResult());
} else {
    print_r($packages->getLastError());
}
/**
 * Sample call for packagesPickupCallV1 operation/method
 */
if ($packages->packagesPickupCallV1(new \StructType\PackagesPickupCallV1()) !== false) {
    print_r($packages->getResult());
} else {
    print_r($packages->getLastError());
}
/**
 * Sample call for packagesPickupCallV2 operation/method
 */
if ($packages->packagesPickupCallV2(new \StructType\PackagesPickupCallV2()) !== false) {
    print_r($packages->getResult());
} else {
    print_r($packages->getLastError());
}
/**
 * Samples for Append ServiceType
 */
$append = new \ServiceType\Append($options);
/**
 * Sample call for appendParcelsToPackageV1 operation/method
 */
if ($append->appendParcelsToPackageV1(new \StructType\AppendParcelsToPackageV1()) !== false) {
    print_r($append->getResult());
} else {
    print_r($append->getLastError());
}
/**
 * Sample call for appendParcelsToPackageV2 operation/method
 */
if ($append->appendParcelsToPackageV2(new \StructType\AppendParcelsToPackageV2()) !== false) {
    print_r($append->getResult());
} else {
    print_r($append->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getCourierOrderAvailabilityV1 operation/method
 */
if ($get->getCourierOrderAvailabilityV1(new \StructType\GetCourierOrderAvailabilityV1()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for importDeliveryBusinessEventV1 operation/method
 */
if ($import->importDeliveryBusinessEventV1(new \StructType\ImportDeliveryBusinessEventV1()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
