<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pickupPayerDPPV1 StructType
 * @subpackage Structs
 */
class PickupPayerDPPV1 extends AbstractStructBase
{
    /**
     * The payerCostCenter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerCostCenter;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The payerNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $payerNumber;
    /**
     * Constructor method for pickupPayerDPPV1
     * @uses PickupPayerDPPV1::setPayerCostCenter()
     * @uses PickupPayerDPPV1::setPayerName()
     * @uses PickupPayerDPPV1::setPayerNumber()
     * @param string $payerCostCenter
     * @param string $payerName
     * @param int $payerNumber
     */
    public function __construct($payerCostCenter = null, $payerName = null, $payerNumber = null)
    {
        $this
            ->setPayerCostCenter($payerCostCenter)
            ->setPayerName($payerName)
            ->setPayerNumber($payerNumber);
    }
    /**
     * Get payerCostCenter value
     * @return string|null
     */
    public function getPayerCostCenter()
    {
        return $this->payerCostCenter;
    }
    /**
     * Set payerCostCenter value
     * @param string $payerCostCenter
     * @return \StructType\PickupPayerDPPV1
     */
    public function setPayerCostCenter($payerCostCenter = null)
    {
        // validation for constraint: string
        if (!is_null($payerCostCenter) && !is_string($payerCostCenter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerCostCenter, true), gettype($payerCostCenter)), __LINE__);
        }
        $this->payerCostCenter = $payerCostCenter;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\PickupPayerDPPV1
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get payerNumber value
     * @return int|null
     */
    public function getPayerNumber()
    {
        return $this->payerNumber;
    }
    /**
     * Set payerNumber value
     * @param int $payerNumber
     * @return \StructType\PickupPayerDPPV1
     */
    public function setPayerNumber($payerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($payerNumber) && !(is_int($payerNumber) || ctype_digit($payerNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payerNumber, true), gettype($payerNumber)), __LINE__);
        }
        $this->payerNumber = $payerNumber;
        return $this;
    }
}
