<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagesPickupCallResponseV3 StructType
 * @subpackage Structs
 */
class PackagesPickupCallResponseV3 extends AbstractStructBase
{
    /**
     * The checkSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $checkSum;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatusInfoPCRV2
     */
    public $statusInfo;
    /**
     * Constructor method for packagesPickupCallResponseV3
     * @uses PackagesPickupCallResponseV3::setCheckSum()
     * @uses PackagesPickupCallResponseV3::setOrderNumber()
     * @uses PackagesPickupCallResponseV3::setStatusInfo()
     * @param int $checkSum
     * @param string $orderNumber
     * @param \StructType\StatusInfoPCRV2 $statusInfo
     */
    public function __construct($checkSum = null, $orderNumber = null, \StructType\StatusInfoPCRV2 $statusInfo = null)
    {
        $this
            ->setCheckSum($checkSum)
            ->setOrderNumber($orderNumber)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get checkSum value
     * @return int|null
     */
    public function getCheckSum()
    {
        return $this->checkSum;
    }
    /**
     * Set checkSum value
     * @param int $checkSum
     * @return \StructType\PackagesPickupCallResponseV3
     */
    public function setCheckSum($checkSum = null)
    {
        // validation for constraint: int
        if (!is_null($checkSum) && !(is_int($checkSum) || ctype_digit($checkSum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($checkSum, true), gettype($checkSum)), __LINE__);
        }
        $this->checkSum = $checkSum;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\PackagesPickupCallResponseV3
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \StructType\StatusInfoPCRV2|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \StructType\StatusInfoPCRV2 $statusInfo
     * @return \StructType\PackagesPickupCallResponseV3
     */
    public function setStatusInfo(\StructType\StatusInfoPCRV2 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
