<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagePGRV1 StructType
 * @subpackage Structs
 */
class PackagePGRV1 extends AbstractStructBase
{
    /**
     * The invalidFields
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvalidFieldPGRV1[]
     */
    public $invalidFields;
    /**
     * The packageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelPGRV1[]
     */
    public $parcels;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for packagePGRV1
     * @uses PackagePGRV1::setInvalidFields()
     * @uses PackagePGRV1::setPackageId()
     * @uses PackagePGRV1::setParcels()
     * @uses PackagePGRV1::setReference()
     * @uses PackagePGRV1::setStatus()
     * @param \StructType\InvalidFieldPGRV1[] $invalidFields
     * @param int $packageId
     * @param \StructType\ParcelPGRV1[] $parcels
     * @param string $reference
     * @param string $status
     */
    public function __construct(array $invalidFields = array(), $packageId = null, array $parcels = array(), $reference = null, $status = null)
    {
        $this
            ->setInvalidFields($invalidFields)
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference)
            ->setStatus($status);
    }
    /**
     * Get invalidFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvalidFieldPGRV1[]|null
     */
    public function getInvalidFields()
    {
        return isset($this->invalidFields) ? $this->invalidFields : null;
    }
    /**
     * This method is responsible for validating the values passed to the setInvalidFields method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvalidFields method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvalidFieldsForArrayConstraintsFromSetInvalidFields(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagePGRV1InvalidFieldsItem) {
            // validation for constraint: itemType
            if (!$packagePGRV1InvalidFieldsItem instanceof \StructType\InvalidFieldPGRV1) {
                $invalidValues[] = is_object($packagePGRV1InvalidFieldsItem) ? get_class($packagePGRV1InvalidFieldsItem) : sprintf('%s(%s)', gettype($packagePGRV1InvalidFieldsItem), var_export($packagePGRV1InvalidFieldsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The invalidFields property can only contain items of type \StructType\InvalidFieldPGRV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set invalidFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvalidFieldPGRV1[] $invalidFields
     * @return \StructType\PackagePGRV1
     */
    public function setInvalidFields(array $invalidFields = array())
    {
        // validation for constraint: array
        if ('' !== ($invalidFieldsArrayErrorMessage = self::validateInvalidFieldsForArrayConstraintsFromSetInvalidFields($invalidFields))) {
            throw new \InvalidArgumentException($invalidFieldsArrayErrorMessage, __LINE__);
        }
        if (is_null($invalidFields) || (is_array($invalidFields) && empty($invalidFields))) {
            unset($this->invalidFields);
        } else {
            $this->invalidFields = $invalidFields;
        }
        return $this;
    }
    /**
     * Add item to invalidFields value
     * @throws \InvalidArgumentException
     * @param \StructType\InvalidFieldPGRV1 $item
     * @return \StructType\PackagePGRV1
     */
    public function addToInvalidFields(\StructType\InvalidFieldPGRV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvalidFieldPGRV1) {
            throw new \InvalidArgumentException(sprintf('The invalidFields property can only contain items of type \StructType\InvalidFieldPGRV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->invalidFields[] = $item;
        return $this;
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \StructType\PackagePGRV1
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelPGRV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagePGRV1ParcelsItem) {
            // validation for constraint: itemType
            if (!$packagePGRV1ParcelsItem instanceof \StructType\ParcelPGRV1) {
                $invalidValues[] = is_object($packagePGRV1ParcelsItem) ? get_class($packagePGRV1ParcelsItem) : sprintf('%s(%s)', gettype($packagePGRV1ParcelsItem), var_export($packagePGRV1ParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \StructType\ParcelPGRV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelPGRV1[] $parcels
     * @return \StructType\PackagePGRV1
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelPGRV1 $item
     * @return \StructType\PackagePGRV1
     */
    public function addToParcels(\StructType\ParcelPGRV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelPGRV1) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \StructType\ParcelPGRV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\PackagePGRV1
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ValidationStatusPGREnumV1::valueIsValid()
     * @uses \EnumType\ValidationStatusPGREnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PackagePGRV1
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidationStatusPGREnumV1::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ValidationStatusPGREnumV1', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ValidationStatusPGREnumV1::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
}
