<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generateReturnLabelV1 StructType
 * Meta information extracted from the WSDL
 * - type: tns:generateReturnLabelV1
 * @subpackage Structs
 */
class GenerateReturnLabelV1 extends AbstractStructBase
{
    /**
     * The returnedWaybillsV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReturnedWaybillsV1
     */
    public $returnedWaybillsV1;
    /**
     * The receiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PudoReturnReceiver
     */
    public $receiver;
    /**
     * The outputDocFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocFormatV1;
    /**
     * The outputDocPageFormatV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputDocPageFormatV1;
    /**
     * The outputLabelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $outputLabelType;
    /**
     * The labelVariant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelVariant;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generateReturnLabelV1
     * @uses GenerateReturnLabelV1::setReturnedWaybillsV1()
     * @uses GenerateReturnLabelV1::setReceiver()
     * @uses GenerateReturnLabelV1::setOutputDocFormatV1()
     * @uses GenerateReturnLabelV1::setOutputDocPageFormatV1()
     * @uses GenerateReturnLabelV1::setOutputLabelType()
     * @uses GenerateReturnLabelV1::setLabelVariant()
     * @uses GenerateReturnLabelV1::setAuthDataV1()
     * @param \StructType\ReturnedWaybillsV1 $returnedWaybillsV1
     * @param \StructType\PudoReturnReceiver $receiver
     * @param string $outputDocFormatV1
     * @param string $outputDocPageFormatV1
     * @param string $outputLabelType
     * @param string $labelVariant
     * @param \StructType\AuthDataV1 $authDataV1
     */
    public function __construct(\StructType\ReturnedWaybillsV1 $returnedWaybillsV1 = null, \StructType\PudoReturnReceiver $receiver = null, $outputDocFormatV1 = null, $outputDocPageFormatV1 = null, $outputLabelType = null, $labelVariant = null, \StructType\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setReturnedWaybillsV1($returnedWaybillsV1)
            ->setReceiver($receiver)
            ->setOutputDocFormatV1($outputDocFormatV1)
            ->setOutputDocPageFormatV1($outputDocPageFormatV1)
            ->setOutputLabelType($outputLabelType)
            ->setLabelVariant($labelVariant)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get returnedWaybillsV1 value
     * @return \StructType\ReturnedWaybillsV1|null
     */
    public function getReturnedWaybillsV1()
    {
        return $this->returnedWaybillsV1;
    }
    /**
     * Set returnedWaybillsV1 value
     * @param \StructType\ReturnedWaybillsV1 $returnedWaybillsV1
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setReturnedWaybillsV1(\StructType\ReturnedWaybillsV1 $returnedWaybillsV1 = null)
    {
        $this->returnedWaybillsV1 = $returnedWaybillsV1;
        return $this;
    }
    /**
     * Get receiver value
     * @return \StructType\PudoReturnReceiver|null
     */
    public function getReceiver()
    {
        return $this->receiver;
    }
    /**
     * Set receiver value
     * @param \StructType\PudoReturnReceiver $receiver
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setReceiver(\StructType\PudoReturnReceiver $receiver = null)
    {
        $this->receiver = $receiver;
        return $this;
    }
    /**
     * Get outputDocFormatV1 value
     * @return string|null
     */
    public function getOutputDocFormatV1()
    {
        return $this->outputDocFormatV1;
    }
    /**
     * Set outputDocFormatV1 value
     * @uses \EnumType\OutputDocFormatDSPEnumV1::valueIsValid()
     * @uses \EnumType\OutputDocFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocFormatV1
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setOutputDocFormatV1($outputDocFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OutputDocFormatDSPEnumV1::valueIsValid($outputDocFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OutputDocFormatDSPEnumV1', is_array($outputDocFormatV1) ? implode(', ', $outputDocFormatV1) : var_export($outputDocFormatV1, true), implode(', ', \EnumType\OutputDocFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocFormatV1 = $outputDocFormatV1;
        return $this;
    }
    /**
     * Get outputDocPageFormatV1 value
     * @return string|null
     */
    public function getOutputDocPageFormatV1()
    {
        return $this->outputDocPageFormatV1;
    }
    /**
     * Set outputDocPageFormatV1 value
     * @uses \EnumType\OutputDocPageFormatDSPEnumV1::valueIsValid()
     * @uses \EnumType\OutputDocPageFormatDSPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputDocPageFormatV1
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setOutputDocPageFormatV1($outputDocPageFormatV1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OutputDocPageFormatDSPEnumV1::valueIsValid($outputDocPageFormatV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OutputDocPageFormatDSPEnumV1', is_array($outputDocPageFormatV1) ? implode(', ', $outputDocPageFormatV1) : var_export($outputDocPageFormatV1, true), implode(', ', \EnumType\OutputDocPageFormatDSPEnumV1::getValidValues())), __LINE__);
        }
        $this->outputDocPageFormatV1 = $outputDocPageFormatV1;
        return $this;
    }
    /**
     * Get outputLabelType value
     * @return string|null
     */
    public function getOutputLabelType()
    {
        return $this->outputLabelType;
    }
    /**
     * Set outputLabelType value
     * @uses \EnumType\OutputLabelTypeEnumV2::valueIsValid()
     * @uses \EnumType\OutputLabelTypeEnumV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outputLabelType
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setOutputLabelType($outputLabelType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OutputLabelTypeEnumV2::valueIsValid($outputLabelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OutputLabelTypeEnumV2', is_array($outputLabelType) ? implode(', ', $outputLabelType) : var_export($outputLabelType, true), implode(', ', \EnumType\OutputLabelTypeEnumV2::getValidValues())), __LINE__);
        }
        $this->outputLabelType = $outputLabelType;
        return $this;
    }
    /**
     * Get labelVariant value
     * @return string|null
     */
    public function getLabelVariant()
    {
        return $this->labelVariant;
    }
    /**
     * Set labelVariant value
     * @param string $labelVariant
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setLabelVariant($labelVariant = null)
    {
        // validation for constraint: string
        if (!is_null($labelVariant) && !is_string($labelVariant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelVariant, true), gettype($labelVariant)), __LINE__);
        }
        $this->labelVariant = $labelVariant;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \StructType\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \StructType\AuthDataV1 $authDataV1
     * @return \StructType\GenerateReturnLabelV1
     */
    public function setAuthDataV1(\StructType\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
