<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generatePackagesNumbersV7 StructType
 * Meta information extracted from the WSDL
 * - type: tns:generatePackagesNumbersV7
 * @subpackage Structs
 */
class GeneratePackagesNumbersV7 extends AbstractStructBase
{
    /**
     * The openUMLFeV8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OpenUMLFeV8
     */
    public $openUMLFeV8;
    /**
     * The pkgNumsGenerationPolicyV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkgNumsGenerationPolicyV1;
    /**
     * The langCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The authDataV1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AuthDataV1
     */
    public $authDataV1;
    /**
     * Constructor method for generatePackagesNumbersV7
     * @uses GeneratePackagesNumbersV7::setOpenUMLFeV8()
     * @uses GeneratePackagesNumbersV7::setPkgNumsGenerationPolicyV1()
     * @uses GeneratePackagesNumbersV7::setLangCode()
     * @uses GeneratePackagesNumbersV7::setAuthDataV1()
     * @param \StructType\OpenUMLFeV8 $openUMLFeV8
     * @param string $pkgNumsGenerationPolicyV1
     * @param string $langCode
     * @param \StructType\AuthDataV1 $authDataV1
     */
    public function __construct(\StructType\OpenUMLFeV8 $openUMLFeV8 = null, $pkgNumsGenerationPolicyV1 = null, $langCode = null, \StructType\AuthDataV1 $authDataV1 = null)
    {
        $this
            ->setOpenUMLFeV8($openUMLFeV8)
            ->setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1)
            ->setLangCode($langCode)
            ->setAuthDataV1($authDataV1);
    }
    /**
     * Get openUMLFeV8 value
     * @return \StructType\OpenUMLFeV8|null
     */
    public function getOpenUMLFeV8()
    {
        return $this->openUMLFeV8;
    }
    /**
     * Set openUMLFeV8 value
     * @param \StructType\OpenUMLFeV8 $openUMLFeV8
     * @return \StructType\GeneratePackagesNumbersV7
     */
    public function setOpenUMLFeV8(\StructType\OpenUMLFeV8 $openUMLFeV8 = null)
    {
        $this->openUMLFeV8 = $openUMLFeV8;
        return $this;
    }
    /**
     * Get pkgNumsGenerationPolicyV1 value
     * @return string|null
     */
    public function getPkgNumsGenerationPolicyV1()
    {
        return $this->pkgNumsGenerationPolicyV1;
    }
    /**
     * Set pkgNumsGenerationPolicyV1 value
     * @uses \EnumType\PkgNumsGenerationPolicyV1::valueIsValid()
     * @uses \EnumType\PkgNumsGenerationPolicyV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pkgNumsGenerationPolicyV1
     * @return \StructType\GeneratePackagesNumbersV7
     */
    public function setPkgNumsGenerationPolicyV1($pkgNumsGenerationPolicyV1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PkgNumsGenerationPolicyV1::valueIsValid($pkgNumsGenerationPolicyV1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PkgNumsGenerationPolicyV1', is_array($pkgNumsGenerationPolicyV1) ? implode(', ', $pkgNumsGenerationPolicyV1) : var_export($pkgNumsGenerationPolicyV1, true), implode(', ', \EnumType\PkgNumsGenerationPolicyV1::getValidValues())), __LINE__);
        }
        $this->pkgNumsGenerationPolicyV1 = $pkgNumsGenerationPolicyV1;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \StructType\GeneratePackagesNumbersV7
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get authDataV1 value
     * @return \StructType\AuthDataV1|null
     */
    public function getAuthDataV1()
    {
        return $this->authDataV1;
    }
    /**
     * Set authDataV1 value
     * @param \StructType\AuthDataV1 $authDataV1
     * @return \StructType\GeneratePackagesNumbersV7
     */
    public function setAuthDataV1(\StructType\AuthDataV1 $authDataV1 = null)
    {
        $this->authDataV1 = $authDataV1;
        return $this;
    }
}
