<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdServicesParamsV2 StructType
 * @subpackage Structs
 */
class DpdServicesParamsV2 extends AbstractStructBase
{
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Policy;
    /**
     * The Session
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SessionDSPV2
     */
    public $Session;
    /**
     * The PickupAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PickupAddressDSPV2
     */
    public $PickupAddress;
    /**
     * The DeliveryDestinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeliveryDestinations
     */
    public $DeliveryDestinations;
    /**
     * The GenProtForNonMatching
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GenProtForNonMatching;
    /**
     * Constructor method for dpdServicesParamsV2
     * @uses DpdServicesParamsV2::setPolicy()
     * @uses DpdServicesParamsV2::setSession()
     * @uses DpdServicesParamsV2::setPickupAddress()
     * @uses DpdServicesParamsV2::setDeliveryDestinations()
     * @uses DpdServicesParamsV2::setGenProtForNonMatching()
     * @param string $policy
     * @param \StructType\SessionDSPV2 $session
     * @param \StructType\PickupAddressDSPV2 $pickupAddress
     * @param \StructType\DeliveryDestinations $deliveryDestinations
     * @param bool $genProtForNonMatching
     */
    public function __construct($policy = null, \StructType\SessionDSPV2 $session = null, \StructType\PickupAddressDSPV2 $pickupAddress = null, \StructType\DeliveryDestinations $deliveryDestinations = null, $genProtForNonMatching = null)
    {
        $this
            ->setPolicy($policy)
            ->setSession($session)
            ->setPickupAddress($pickupAddress)
            ->setDeliveryDestinations($deliveryDestinations)
            ->setGenProtForNonMatching($genProtForNonMatching);
    }
    /**
     * Get Policy value
     * @return string|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * Set Policy value
     * @uses \EnumType\PolicyDSPEnumV2::valueIsValid()
     * @uses \EnumType\PolicyDSPEnumV2::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policy
     * @return \StructType\DpdServicesParamsV2
     */
    public function setPolicy($policy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyDSPEnumV2::valueIsValid($policy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyDSPEnumV2', is_array($policy) ? implode(', ', $policy) : var_export($policy, true), implode(', ', \EnumType\PolicyDSPEnumV2::getValidValues())), __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Get Session value
     * @return \StructType\SessionDSPV2|null
     */
    public function getSession()
    {
        return $this->Session;
    }
    /**
     * Set Session value
     * @param \StructType\SessionDSPV2 $session
     * @return \StructType\DpdServicesParamsV2
     */
    public function setSession(\StructType\SessionDSPV2 $session = null)
    {
        $this->Session = $session;
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return \StructType\PickupAddressDSPV2|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \StructType\PickupAddressDSPV2 $pickupAddress
     * @return \StructType\DpdServicesParamsV2
     */
    public function setPickupAddress(\StructType\PickupAddressDSPV2 $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get DeliveryDestinations value
     * @return \StructType\DeliveryDestinations|null
     */
    public function getDeliveryDestinations()
    {
        return $this->DeliveryDestinations;
    }
    /**
     * Set DeliveryDestinations value
     * @param \StructType\DeliveryDestinations $deliveryDestinations
     * @return \StructType\DpdServicesParamsV2
     */
    public function setDeliveryDestinations(\StructType\DeliveryDestinations $deliveryDestinations = null)
    {
        $this->DeliveryDestinations = $deliveryDestinations;
        return $this;
    }
    /**
     * Get GenProtForNonMatching value
     * @return bool|null
     */
    public function getGenProtForNonMatching()
    {
        return $this->GenProtForNonMatching;
    }
    /**
     * Set GenProtForNonMatching value
     * @param bool $genProtForNonMatching
     * @return \StructType\DpdServicesParamsV2
     */
    public function setGenProtForNonMatching($genProtForNonMatching = null)
    {
        // validation for constraint: boolean
        if (!is_null($genProtForNonMatching) && !is_bool($genProtForNonMatching)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($genProtForNonMatching, true), gettype($genProtForNonMatching)), __LINE__);
        }
        $this->GenProtForNonMatching = $genProtForNonMatching;
        return $this;
    }
}
