<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdPickupCallParamsV1 StructType
 * @subpackage Structs
 */
class DpdPickupCallParamsV1 extends AbstractStructBase
{
    /**
     * The contactInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactInfoDPPV1
     */
    public $contactInfo;
    /**
     * The pickupAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PickupAddressDSPV1
     */
    public $pickupAddress;
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupDate;
    /**
     * The pickupTimeFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeFrom;
    /**
     * The pickupTimeTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickupTimeTo;
    /**
     * The policy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $policy;
    /**
     * The protocols
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProtocolDPPV1[]
     */
    public $protocols;
    /**
     * Constructor method for dpdPickupCallParamsV1
     * @uses DpdPickupCallParamsV1::setContactInfo()
     * @uses DpdPickupCallParamsV1::setPickupAddress()
     * @uses DpdPickupCallParamsV1::setPickupDate()
     * @uses DpdPickupCallParamsV1::setPickupTimeFrom()
     * @uses DpdPickupCallParamsV1::setPickupTimeTo()
     * @uses DpdPickupCallParamsV1::setPolicy()
     * @uses DpdPickupCallParamsV1::setProtocols()
     * @param \StructType\ContactInfoDPPV1 $contactInfo
     * @param \StructType\PickupAddressDSPV1 $pickupAddress
     * @param string $pickupDate
     * @param string $pickupTimeFrom
     * @param string $pickupTimeTo
     * @param string $policy
     * @param \StructType\ProtocolDPPV1[] $protocols
     */
    public function __construct(\StructType\ContactInfoDPPV1 $contactInfo = null, \StructType\PickupAddressDSPV1 $pickupAddress = null, $pickupDate = null, $pickupTimeFrom = null, $pickupTimeTo = null, $policy = null, array $protocols = array())
    {
        $this
            ->setContactInfo($contactInfo)
            ->setPickupAddress($pickupAddress)
            ->setPickupDate($pickupDate)
            ->setPickupTimeFrom($pickupTimeFrom)
            ->setPickupTimeTo($pickupTimeTo)
            ->setPolicy($policy)
            ->setProtocols($protocols);
    }
    /**
     * Get contactInfo value
     * @return \StructType\ContactInfoDPPV1|null
     */
    public function getContactInfo()
    {
        return $this->contactInfo;
    }
    /**
     * Set contactInfo value
     * @param \StructType\ContactInfoDPPV1 $contactInfo
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setContactInfo(\StructType\ContactInfoDPPV1 $contactInfo = null)
    {
        $this->contactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get pickupAddress value
     * @return \StructType\PickupAddressDSPV1|null
     */
    public function getPickupAddress()
    {
        return $this->pickupAddress;
    }
    /**
     * Set pickupAddress value
     * @param \StructType\PickupAddressDSPV1 $pickupAddress
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setPickupAddress(\StructType\PickupAddressDSPV1 $pickupAddress = null)
    {
        $this->pickupAddress = $pickupAddress;
        return $this;
    }
    /**
     * Get pickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get pickupTimeFrom value
     * @return string|null
     */
    public function getPickupTimeFrom()
    {
        return $this->pickupTimeFrom;
    }
    /**
     * Set pickupTimeFrom value
     * @param string $pickupTimeFrom
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setPickupTimeFrom($pickupTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeFrom) && !is_string($pickupTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeFrom, true), gettype($pickupTimeFrom)), __LINE__);
        }
        $this->pickupTimeFrom = $pickupTimeFrom;
        return $this;
    }
    /**
     * Get pickupTimeTo value
     * @return string|null
     */
    public function getPickupTimeTo()
    {
        return $this->pickupTimeTo;
    }
    /**
     * Set pickupTimeTo value
     * @param string $pickupTimeTo
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setPickupTimeTo($pickupTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($pickupTimeTo) && !is_string($pickupTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupTimeTo, true), gettype($pickupTimeTo)), __LINE__);
        }
        $this->pickupTimeTo = $pickupTimeTo;
        return $this;
    }
    /**
     * Get policy value
     * @return string|null
     */
    public function getPolicy()
    {
        return $this->policy;
    }
    /**
     * Set policy value
     * @uses \EnumType\PolicyDPPEnumV1::valueIsValid()
     * @uses \EnumType\PolicyDPPEnumV1::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $policy
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setPolicy($policy = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PolicyDPPEnumV1::valueIsValid($policy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PolicyDPPEnumV1', is_array($policy) ? implode(', ', $policy) : var_export($policy, true), implode(', ', \EnumType\PolicyDPPEnumV1::getValidValues())), __LINE__);
        }
        $this->policy = $policy;
        return $this;
    }
    /**
     * Get protocols value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProtocolDPPV1[]|null
     */
    public function getProtocols()
    {
        return isset($this->protocols) ? $this->protocols : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProtocols method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProtocols method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProtocolsForArrayConstraintsFromSetProtocols(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dpdPickupCallParamsV1ProtocolsItem) {
            // validation for constraint: itemType
            if (!$dpdPickupCallParamsV1ProtocolsItem instanceof \StructType\ProtocolDPPV1) {
                $invalidValues[] = is_object($dpdPickupCallParamsV1ProtocolsItem) ? get_class($dpdPickupCallParamsV1ProtocolsItem) : sprintf('%s(%s)', gettype($dpdPickupCallParamsV1ProtocolsItem), var_export($dpdPickupCallParamsV1ProtocolsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The protocols property can only contain items of type \StructType\ProtocolDPPV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set protocols value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProtocolDPPV1[] $protocols
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function setProtocols(array $protocols = array())
    {
        // validation for constraint: array
        if ('' !== ($protocolsArrayErrorMessage = self::validateProtocolsForArrayConstraintsFromSetProtocols($protocols))) {
            throw new \InvalidArgumentException($protocolsArrayErrorMessage, __LINE__);
        }
        if (is_null($protocols) || (is_array($protocols) && empty($protocols))) {
            unset($this->protocols);
        } else {
            $this->protocols = $protocols;
        }
        return $this;
    }
    /**
     * Add item to protocols value
     * @throws \InvalidArgumentException
     * @param \StructType\ProtocolDPPV1 $item
     * @return \StructType\DpdPickupCallParamsV1
     */
    public function addToProtocols(\StructType\ProtocolDPPV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProtocolDPPV1) {
            throw new \InvalidArgumentException(sprintf('The protocols property can only contain items of type \StructType\ProtocolDPPV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->protocols[] = $item;
        return $this;
    }
}
