<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for validationInfoPGRV2 StructType
 * @subpackage Structs
 */
class ValidationInfoPGRV2 extends AbstractStructBase
{
    /**
     * The ErrorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ErrorId;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ErrorCode;
    /**
     * The FieldNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FieldNames;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * Constructor method for validationInfoPGRV2
     * @uses ValidationInfoPGRV2::setErrorId()
     * @uses ValidationInfoPGRV2::setErrorCode()
     * @uses ValidationInfoPGRV2::setFieldNames()
     * @uses ValidationInfoPGRV2::setInfo()
     * @param int $errorId
     * @param string $errorCode
     * @param string $fieldNames
     * @param string $info
     */
    public function __construct($errorId = null, $errorCode = null, $fieldNames = null, $info = null)
    {
        $this
            ->setErrorId($errorId)
            ->setErrorCode($errorCode)
            ->setFieldNames($fieldNames)
            ->setInfo($info);
    }
    /**
     * Get ErrorId value
     * @return int|null
     */
    public function getErrorId()
    {
        return $this->ErrorId;
    }
    /**
     * Set ErrorId value
     * @param int $errorId
     * @return \StructType\ValidationInfoPGRV2
     */
    public function setErrorId($errorId = null)
    {
        // validation for constraint: int
        if (!is_null($errorId) && !(is_int($errorId) || ctype_digit($errorId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorId, true), gettype($errorId)), __LINE__);
        }
        $this->ErrorId = $errorId;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \StructType\ValidationInfoPGRV2
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get FieldNames value
     * @return string|null
     */
    public function getFieldNames()
    {
        return $this->FieldNames;
    }
    /**
     * Set FieldNames value
     * @param string $fieldNames
     * @return \StructType\ValidationInfoPGRV2
     */
    public function setFieldNames($fieldNames = null)
    {
        // validation for constraint: string
        if (!is_null($fieldNames) && !is_string($fieldNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fieldNames, true), gettype($fieldNames)), __LINE__);
        }
        $this->FieldNames = $fieldNames;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \StructType\ValidationInfoPGRV2
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
}
