<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationDetails StructType
 * @subpackage Structs
 */
class ValidationDetails extends AbstractStructBase
{
    /**
     * The ValidationInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ValidationInfoPGRV2[]
     */
    public $ValidationInfo;
    /**
     * Constructor method for ValidationDetails
     * @uses ValidationDetails::setValidationInfo()
     * @param \StructType\ValidationInfoPGRV2[] $validationInfo
     */
    public function __construct(array $validationInfo = array())
    {
        $this
            ->setValidationInfo($validationInfo);
    }
    /**
     * Get ValidationInfo value
     * @return \StructType\ValidationInfoPGRV2[]|null
     */
    public function getValidationInfo()
    {
        return $this->ValidationInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setValidationInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValidationInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValidationInfoForArrayConstraintsFromSetValidationInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $validationDetailsValidationInfoItem) {
            // validation for constraint: itemType
            if (!$validationDetailsValidationInfoItem instanceof \StructType\ValidationInfoPGRV2) {
                $invalidValues[] = is_object($validationDetailsValidationInfoItem) ? get_class($validationDetailsValidationInfoItem) : sprintf('%s(%s)', gettype($validationDetailsValidationInfoItem), var_export($validationDetailsValidationInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ValidationInfo property can only contain items of type \StructType\ValidationInfoPGRV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ValidationInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationInfoPGRV2[] $validationInfo
     * @return \StructType\ValidationDetails
     */
    public function setValidationInfo(array $validationInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($validationInfoArrayErrorMessage = self::validateValidationInfoForArrayConstraintsFromSetValidationInfo($validationInfo))) {
            throw new \InvalidArgumentException($validationInfoArrayErrorMessage, __LINE__);
        }
        $this->ValidationInfo = $validationInfo;
        return $this;
    }
    /**
     * Add item to ValidationInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ValidationInfoPGRV2 $item
     * @return \StructType\ValidationDetails
     */
    public function addToValidationInfo(\StructType\ValidationInfoPGRV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ValidationInfoPGRV2) {
            throw new \InvalidArgumentException(sprintf('The ValidationInfo property can only contain items of type \StructType\ValidationInfoPGRV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ValidationInfo[] = $item;
        return $this;
    }
}
