<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for shipmentDocumentGenerationSessionV1 StructType
 * @subpackage Structs
 */
class ShipmentDocumentGenerationSessionV1 extends AbstractStructBase
{
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PackageDGRV1[]
     */
    public $packages;
    /**
     * The sessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sessionId;
    /**
     * The statusInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ShipmentDocumentGenerationStatusInfoV1
     */
    public $statusInfo;
    /**
     * Constructor method for shipmentDocumentGenerationSessionV1
     * @uses ShipmentDocumentGenerationSessionV1::setPackages()
     * @uses ShipmentDocumentGenerationSessionV1::setSessionId()
     * @uses ShipmentDocumentGenerationSessionV1::setStatusInfo()
     * @param \StructType\PackageDGRV1[] $packages
     * @param int $sessionId
     * @param \StructType\ShipmentDocumentGenerationStatusInfoV1 $statusInfo
     */
    public function __construct(array $packages = array(), $sessionId = null, \StructType\ShipmentDocumentGenerationStatusInfoV1 $statusInfo = null)
    {
        $this
            ->setPackages($packages)
            ->setSessionId($sessionId)
            ->setStatusInfo($statusInfo);
    }
    /**
     * Get packages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PackageDGRV1[]|null
     */
    public function getPackages()
    {
        return isset($this->packages) ? $this->packages : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shipmentDocumentGenerationSessionV1PackagesItem) {
            // validation for constraint: itemType
            if (!$shipmentDocumentGenerationSessionV1PackagesItem instanceof \StructType\PackageDGRV1) {
                $invalidValues[] = is_object($shipmentDocumentGenerationSessionV1PackagesItem) ? get_class($shipmentDocumentGenerationSessionV1PackagesItem) : sprintf('%s(%s)', gettype($shipmentDocumentGenerationSessionV1PackagesItem), var_export($shipmentDocumentGenerationSessionV1PackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \StructType\PackageDGRV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PackageDGRV1[] $packages
     * @return \StructType\ShipmentDocumentGenerationSessionV1
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        if (is_null($packages) || (is_array($packages) && empty($packages))) {
            unset($this->packages);
        } else {
            $this->packages = $packages;
        }
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \StructType\PackageDGRV1 $item
     * @return \StructType\ShipmentDocumentGenerationSessionV1
     */
    public function addToPackages(\StructType\PackageDGRV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackageDGRV1) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \StructType\PackageDGRV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Get sessionId value
     * @return int|null
     */
    public function getSessionId()
    {
        return $this->sessionId;
    }
    /**
     * Set sessionId value
     * @param int $sessionId
     * @return \StructType\ShipmentDocumentGenerationSessionV1
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: int
        if (!is_null($sessionId) && !(is_int($sessionId) || ctype_digit($sessionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        $this->sessionId = $sessionId;
        return $this;
    }
    /**
     * Get statusInfo value
     * @return \StructType\ShipmentDocumentGenerationStatusInfoV1|null
     */
    public function getStatusInfo()
    {
        return $this->statusInfo;
    }
    /**
     * Set statusInfo value
     * @param \StructType\ShipmentDocumentGenerationStatusInfoV1 $statusInfo
     * @return \StructType\ShipmentDocumentGenerationSessionV1
     */
    public function setStatusInfo(\StructType\ShipmentDocumentGenerationStatusInfoV1 $statusInfo = null)
    {
        $this->statusInfo = $statusInfo;
        return $this;
    }
}
