<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelsAppendSearchCriteriaPAV1 StructType
 * @subpackage Structs
 */
class ParcelsAppendSearchCriteriaPAV1 extends AbstractStructBase
{
    /**
     * The packageId
     * @var int
     */
    public $packageId;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for parcelsAppendSearchCriteriaPAV1
     * @uses ParcelsAppendSearchCriteriaPAV1::setPackageId()
     * @uses ParcelsAppendSearchCriteriaPAV1::setReference()
     * @uses ParcelsAppendSearchCriteriaPAV1::setWaybill()
     * @param int $packageId
     * @param string $reference
     * @param string $waybill
     */
    public function __construct($packageId = null, $reference = null, $waybill = null)
    {
        $this
            ->setPackageId($packageId)
            ->setReference($reference)
            ->setWaybill($waybill);
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \StructType\ParcelsAppendSearchCriteriaPAV1
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\ParcelsAppendSearchCriteriaPAV1
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \StructType\ParcelsAppendSearchCriteriaPAV1
     */
    public function setWaybill($waybill = null)
    {
        // validation for constraint: string
        if (!is_null($waybill) && !is_string($waybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybill, true), gettype($waybill)), __LINE__);
        }
        $this->waybill = $waybill;
        return $this;
    }
}
