<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parcelPGRV2 StructType
 * @subpackage Structs
 */
class ParcelPGRV2 extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The ParcelId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelId;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * The Waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Waybill;
    /**
     * The ValidationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ValidationDetails
     */
    public $ValidationDetails;
    /**
     * Constructor method for parcelPGRV2
     * @uses ParcelPGRV2::setStatus()
     * @uses ParcelPGRV2::setParcelId()
     * @uses ParcelPGRV2::setReference()
     * @uses ParcelPGRV2::setWaybill()
     * @uses ParcelPGRV2::setValidationDetails()
     * @param string $status
     * @param int $parcelId
     * @param string $reference
     * @param string $waybill
     * @param \StructType\ValidationDetails $validationDetails
     */
    public function __construct($status = null, $parcelId = null, $reference = null, $waybill = null, \StructType\ValidationDetails $validationDetails = null)
    {
        $this
            ->setStatus($status)
            ->setParcelId($parcelId)
            ->setReference($reference)
            ->setWaybill($waybill)
            ->setValidationDetails($validationDetails);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\ParcelPGRV2
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ParcelId value
     * @return int|null
     */
    public function getParcelId()
    {
        return $this->ParcelId;
    }
    /**
     * Set ParcelId value
     * @param int $parcelId
     * @return \StructType\ParcelPGRV2
     */
    public function setParcelId($parcelId = null)
    {
        // validation for constraint: int
        if (!is_null($parcelId) && !(is_int($parcelId) || ctype_digit($parcelId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelId, true), gettype($parcelId)), __LINE__);
        }
        $this->ParcelId = $parcelId;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\ParcelPGRV2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Get Waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->Waybill;
    }
    /**
     * Set Waybill value
     * @param string $waybill
     * @return \StructType\ParcelPGRV2
     */
    public function setWaybill($waybill = null)
    {
        // validation for constraint: string
        if (!is_null($waybill) && !is_string($waybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybill, true), gettype($waybill)), __LINE__);
        }
        $this->Waybill = $waybill;
        return $this;
    }
    /**
     * Get ValidationDetails value
     * @return \StructType\ValidationDetails|null
     */
    public function getValidationDetails()
    {
        return $this->ValidationDetails;
    }
    /**
     * Set ValidationDetails value
     * @param \StructType\ValidationDetails $validationDetails
     * @return \StructType\ParcelPGRV2
     */
    public function setValidationDetails(\StructType\ValidationDetails $validationDetails = null)
    {
        $this->ValidationDetails = $validationDetails;
        return $this;
    }
}
