<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packagesPickupCallResponseV1 StructType
 * @subpackage Structs
 */
class PackagesPickupCallResponseV1 extends AbstractStructBase
{
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderNumber;
    /**
     * The prototocols
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProtocolPCRV1[]
     */
    public $prototocols;
    /**
     * Constructor method for packagesPickupCallResponseV1
     * @uses PackagesPickupCallResponseV1::setOrderNumber()
     * @uses PackagesPickupCallResponseV1::setPrototocols()
     * @param string $orderNumber
     * @param \StructType\ProtocolPCRV1[] $prototocols
     */
    public function __construct($orderNumber = null, array $prototocols = array())
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setPrototocols($prototocols);
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\PackagesPickupCallResponseV1
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get prototocols value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProtocolPCRV1[]|null
     */
    public function getPrototocols()
    {
        return isset($this->prototocols) ? $this->prototocols : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrototocols method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrototocols method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrototocolsForArrayConstraintsFromSetPrototocols(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagesPickupCallResponseV1PrototocolsItem) {
            // validation for constraint: itemType
            if (!$packagesPickupCallResponseV1PrototocolsItem instanceof \StructType\ProtocolPCRV1) {
                $invalidValues[] = is_object($packagesPickupCallResponseV1PrototocolsItem) ? get_class($packagesPickupCallResponseV1PrototocolsItem) : sprintf('%s(%s)', gettype($packagesPickupCallResponseV1PrototocolsItem), var_export($packagesPickupCallResponseV1PrototocolsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The prototocols property can only contain items of type \StructType\ProtocolPCRV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set prototocols value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProtocolPCRV1[] $prototocols
     * @return \StructType\PackagesPickupCallResponseV1
     */
    public function setPrototocols(array $prototocols = array())
    {
        // validation for constraint: array
        if ('' !== ($prototocolsArrayErrorMessage = self::validatePrototocolsForArrayConstraintsFromSetPrototocols($prototocols))) {
            throw new \InvalidArgumentException($prototocolsArrayErrorMessage, __LINE__);
        }
        if (is_null($prototocols) || (is_array($prototocols) && empty($prototocols))) {
            unset($this->prototocols);
        } else {
            $this->prototocols = $prototocols;
        }
        return $this;
    }
    /**
     * Add item to prototocols value
     * @throws \InvalidArgumentException
     * @param \StructType\ProtocolPCRV1 $item
     * @return \StructType\PackagesPickupCallResponseV1
     */
    public function addToPrototocols(\StructType\ProtocolPCRV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProtocolPCRV1) {
            throw new \InvalidArgumentException(sprintf('The prototocols property can only contain items of type \StructType\ProtocolPCRV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->prototocols[] = $item;
        return $this;
    }
}
