<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Packages StructType
 * @subpackage Structs
 */
class Packages extends AbstractStructBase
{
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PackagePGRV2[]
     */
    public $Package;
    /**
     * Constructor method for Packages
     * @uses Packages::setPackage()
     * @param \StructType\PackagePGRV2[] $package
     */
    public function __construct(array $package = array())
    {
        $this
            ->setPackage($package);
    }
    /**
     * Get Package value
     * @return \StructType\PackagePGRV2[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packagesPackageItem) {
            // validation for constraint: itemType
            if (!$packagesPackageItem instanceof \StructType\PackagePGRV2) {
                $invalidValues[] = is_object($packagesPackageItem) ? get_class($packagesPackageItem) : sprintf('%s(%s)', gettype($packagesPackageItem), var_export($packagesPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \StructType\PackagePGRV2, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \StructType\PackagePGRV2[] $package
     * @return \StructType\Packages
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \StructType\PackagePGRV2 $item
     * @return \StructType\Packages
     */
    public function addToPackage(\StructType\PackagePGRV2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PackagePGRV2) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \StructType\PackagePGRV2, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
}
