<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageDSPV2 StructType
 * @subpackage Structs
 */
class PackageDSPV2 extends AbstractStructBase
{
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackageId;
    /**
     * The Parcels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Parcels
     */
    public $Parcels;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Reference;
    /**
     * Constructor method for packageDSPV2
     * @uses PackageDSPV2::setPackageId()
     * @uses PackageDSPV2::setParcels()
     * @uses PackageDSPV2::setReference()
     * @param int $packageId
     * @param \StructType\Parcels $parcels
     * @param string $reference
     */
    public function __construct($packageId = null, \StructType\Parcels $parcels = null, $reference = null)
    {
        $this
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference);
    }
    /**
     * Get PackageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param int $packageId
     * @return \StructType\PackageDSPV2
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get Parcels value
     * @return \StructType\Parcels|null
     */
    public function getParcels()
    {
        return $this->Parcels;
    }
    /**
     * Set Parcels value
     * @param \StructType\Parcels $parcels
     * @return \StructType\PackageDSPV2
     */
    public function setParcels(\StructType\Parcels $parcels = null)
    {
        $this->Parcels = $parcels;
        return $this;
    }
    /**
     * Get Reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @param string $reference
     * @return \StructType\PackageDSPV2
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->Reference = $reference;
        return $this;
    }
}
