<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageDSPV1 StructType
 * @subpackage Structs
 */
class PackageDSPV1 extends AbstractStructBase
{
    /**
     * The packageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $packageId;
    /**
     * The parcels
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ParcelDSPV1[]
     */
    public $parcels;
    /**
     * The reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reference;
    /**
     * Constructor method for packageDSPV1
     * @uses PackageDSPV1::setPackageId()
     * @uses PackageDSPV1::setParcels()
     * @uses PackageDSPV1::setReference()
     * @param int $packageId
     * @param \StructType\ParcelDSPV1[] $parcels
     * @param string $reference
     */
    public function __construct($packageId = null, array $parcels = array(), $reference = null)
    {
        $this
            ->setPackageId($packageId)
            ->setParcels($parcels)
            ->setReference($reference);
    }
    /**
     * Get packageId value
     * @return int|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param int $packageId
     * @return \StructType\PackageDSPV1
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: int
        if (!is_null($packageId) && !(is_int($packageId) || ctype_digit($packageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get parcels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ParcelDSPV1[]|null
     */
    public function getParcels()
    {
        return isset($this->parcels) ? $this->parcels : null;
    }
    /**
     * This method is responsible for validating the values passed to the setParcels method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParcels method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParcelsForArrayConstraintsFromSetParcels(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $packageDSPV1ParcelsItem) {
            // validation for constraint: itemType
            if (!$packageDSPV1ParcelsItem instanceof \StructType\ParcelDSPV1) {
                $invalidValues[] = is_object($packageDSPV1ParcelsItem) ? get_class($packageDSPV1ParcelsItem) : sprintf('%s(%s)', gettype($packageDSPV1ParcelsItem), var_export($packageDSPV1ParcelsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parcels property can only contain items of type \StructType\ParcelDSPV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parcels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelDSPV1[] $parcels
     * @return \StructType\PackageDSPV1
     */
    public function setParcels(array $parcels = array())
    {
        // validation for constraint: array
        if ('' !== ($parcelsArrayErrorMessage = self::validateParcelsForArrayConstraintsFromSetParcels($parcels))) {
            throw new \InvalidArgumentException($parcelsArrayErrorMessage, __LINE__);
        }
        if (is_null($parcels) || (is_array($parcels) && empty($parcels))) {
            unset($this->parcels);
        } else {
            $this->parcels = $parcels;
        }
        return $this;
    }
    /**
     * Add item to parcels value
     * @throws \InvalidArgumentException
     * @param \StructType\ParcelDSPV1 $item
     * @return \StructType\PackageDSPV1
     */
    public function addToParcels(\StructType\ParcelDSPV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParcelDSPV1) {
            throw new \InvalidArgumentException(sprintf('The parcels property can only contain items of type \StructType\ParcelDSPV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parcels[] = $item;
        return $this;
    }
    /**
     * Get reference value
     * @return string|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param string $reference
     * @return \StructType\PackageDSPV1
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        $this->reference = $reference;
        return $this;
    }
}
