<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for dpdParcelBusinessEventV1 StructType
 * @subpackage Structs
 */
class DpdParcelBusinessEventV1 extends AbstractStructBase
{
    /**
     * The countryCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $countryCode;
    /**
     * The eventCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventCode;
    /**
     * The eventDataList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DpdParcelBusinessEventDataV1[]
     */
    public $eventDataList;
    /**
     * The eventTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $eventTime;
    /**
     * The postalCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postalCode;
    /**
     * The waybill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $waybill;
    /**
     * Constructor method for dpdParcelBusinessEventV1
     * @uses DpdParcelBusinessEventV1::setCountryCode()
     * @uses DpdParcelBusinessEventV1::setEventCode()
     * @uses DpdParcelBusinessEventV1::setEventDataList()
     * @uses DpdParcelBusinessEventV1::setEventTime()
     * @uses DpdParcelBusinessEventV1::setPostalCode()
     * @uses DpdParcelBusinessEventV1::setWaybill()
     * @param string $countryCode
     * @param string $eventCode
     * @param \StructType\DpdParcelBusinessEventDataV1[] $eventDataList
     * @param string $eventTime
     * @param string $postalCode
     * @param string $waybill
     */
    public function __construct($countryCode = null, $eventCode = null, array $eventDataList = array(), $eventTime = null, $postalCode = null, $waybill = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setEventCode($eventCode)
            ->setEventDataList($eventDataList)
            ->setEventTime($eventTime)
            ->setPostalCode($postalCode)
            ->setWaybill($waybill);
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get eventCode value
     * @return string|null
     */
    public function getEventCode()
    {
        return $this->eventCode;
    }
    /**
     * Set eventCode value
     * @param string $eventCode
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: string
        if (!is_null($eventCode) && !is_string($eventCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        $this->eventCode = $eventCode;
        return $this;
    }
    /**
     * Get eventDataList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DpdParcelBusinessEventDataV1[]|null
     */
    public function getEventDataList()
    {
        return isset($this->eventDataList) ? $this->eventDataList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEventDataList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEventDataList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEventDataListForArrayConstraintsFromSetEventDataList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dpdParcelBusinessEventV1EventDataListItem) {
            // validation for constraint: itemType
            if (!$dpdParcelBusinessEventV1EventDataListItem instanceof \StructType\DpdParcelBusinessEventDataV1) {
                $invalidValues[] = is_object($dpdParcelBusinessEventV1EventDataListItem) ? get_class($dpdParcelBusinessEventV1EventDataListItem) : sprintf('%s(%s)', gettype($dpdParcelBusinessEventV1EventDataListItem), var_export($dpdParcelBusinessEventV1EventDataListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The eventDataList property can only contain items of type \StructType\DpdParcelBusinessEventDataV1, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set eventDataList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DpdParcelBusinessEventDataV1[] $eventDataList
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function setEventDataList(array $eventDataList = array())
    {
        // validation for constraint: array
        if ('' !== ($eventDataListArrayErrorMessage = self::validateEventDataListForArrayConstraintsFromSetEventDataList($eventDataList))) {
            throw new \InvalidArgumentException($eventDataListArrayErrorMessage, __LINE__);
        }
        if (is_null($eventDataList) || (is_array($eventDataList) && empty($eventDataList))) {
            unset($this->eventDataList);
        } else {
            $this->eventDataList = $eventDataList;
        }
        return $this;
    }
    /**
     * Add item to eventDataList value
     * @throws \InvalidArgumentException
     * @param \StructType\DpdParcelBusinessEventDataV1 $item
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function addToEventDataList(\StructType\DpdParcelBusinessEventDataV1 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DpdParcelBusinessEventDataV1) {
            throw new \InvalidArgumentException(sprintf('The eventDataList property can only contain items of type \StructType\DpdParcelBusinessEventDataV1, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->eventDataList[] = $item;
        return $this;
    }
    /**
     * Get eventTime value
     * @return string|null
     */
    public function getEventTime()
    {
        return $this->eventTime;
    }
    /**
     * Set eventTime value
     * @param string $eventTime
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function setEventTime($eventTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventTime) && !is_string($eventTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTime, true), gettype($eventTime)), __LINE__);
        }
        $this->eventTime = $eventTime;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get waybill value
     * @return string|null
     */
    public function getWaybill()
    {
        return $this->waybill;
    }
    /**
     * Set waybill value
     * @param string $waybill
     * @return \StructType\DpdParcelBusinessEventV1
     */
    public function setWaybill($waybill = null)
    {
        // validation for constraint: string
        if (!is_null($waybill) && !is_string($waybill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybill, true), gettype($waybill)), __LINE__);
        }
        $this->waybill = $waybill;
        return $this;
    }
}
