<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentGenerationResponseV1 StructType
 * @subpackage Structs
 */
class DocumentGenerationResponseV1 extends AbstractStructBase
{
    /**
     * The documentData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentData;
    /**
     * The documentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $documentId;
    /**
     * The session
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SessionDGRV1
     */
    public $session;
    /**
     * Constructor method for documentGenerationResponseV1
     * @uses DocumentGenerationResponseV1::setDocumentData()
     * @uses DocumentGenerationResponseV1::setDocumentId()
     * @uses DocumentGenerationResponseV1::setSession()
     * @param string $documentData
     * @param string $documentId
     * @param \StructType\SessionDGRV1 $session
     */
    public function __construct($documentData = null, $documentId = null, \StructType\SessionDGRV1 $session = null)
    {
        $this
            ->setDocumentData($documentData)
            ->setDocumentId($documentId)
            ->setSession($session);
    }
    /**
     * Get documentData value
     * @return string|null
     */
    public function getDocumentData()
    {
        return $this->documentData;
    }
    /**
     * Set documentData value
     * @param string $documentData
     * @return \StructType\DocumentGenerationResponseV1
     */
    public function setDocumentData($documentData = null)
    {
        // validation for constraint: string
        if (!is_null($documentData) && !is_string($documentData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentData, true), gettype($documentData)), __LINE__);
        }
        $this->documentData = $documentData;
        return $this;
    }
    /**
     * Get documentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->documentId;
    }
    /**
     * Set documentId value
     * @param string $documentId
     * @return \StructType\DocumentGenerationResponseV1
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        $this->documentId = $documentId;
        return $this;
    }
    /**
     * Get session value
     * @return \StructType\SessionDGRV1|null
     */
    public function getSession()
    {
        return $this->session;
    }
    /**
     * Set session value
     * @param \StructType\SessionDGRV1 $session
     * @return \StructType\DocumentGenerationResponseV1
     */
    public function setSession(\StructType\SessionDGRV1 $session = null)
    {
        $this->session = $session;
        return $this;
    }
}
