<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named importDeliveryBusinessEventV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportDeliveryBusinessEventV1 $parameters
     * @return \StructType\ImportDeliveryBusinessEventV1Response|bool
     */
    public function importDeliveryBusinessEventV1(\StructType\ImportDeliveryBusinessEventV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->importDeliveryBusinessEventV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportDeliveryBusinessEventV1Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
