<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Append ServiceType
 * @subpackage Services
 */
class Append extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named appendParcelsToPackageV1
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AppendParcelsToPackageV1 $parameters
     * @return \StructType\AppendParcelsToPackageV1Response|bool
     */
    public function appendParcelsToPackageV1(\StructType\AppendParcelsToPackageV1 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageV1($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named appendParcelsToPackageV2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AppendParcelsToPackageV2 $parameters
     * @return \StructType\AppendParcelsToPackageV2Response|bool
     */
    public function appendParcelsToPackageV2(\StructType\AppendParcelsToPackageV2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->appendParcelsToPackageV2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AppendParcelsToPackageV1Response|\StructType\AppendParcelsToPackageV2Response
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
