<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for validationStatusPGREnumV1 EnumType
 * @subpackage Enumerations
 */
class ValidationStatusPGREnumV1 extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'UNKNOWN_ERROR'
     * @return string 'UNKNOWN_ERROR'
     */
    const VALUE_UNKNOWN_ERROR = 'UNKNOWN_ERROR';
    /**
     * Constant for value 'DB_ERROR'
     * @return string 'DB_ERROR'
     */
    const VALUE_DB_ERROR = 'DB_ERROR';
    /**
     * Constant for value 'INCORRECT_DATA'
     * @return string 'INCORRECT_DATA'
     */
    const VALUE_INCORRECT_DATA = 'INCORRECT_DATA';
    /**
     * Constant for value 'NOT_PROCESSED'
     * @return string 'NOT_PROCESSED'
     */
    const VALUE_NOT_PROCESSED = 'NOT_PROCESSED';
    /**
     * Constant for value 'DUPLICATED_PACKAGE_SEARCH_KEY'
     * @return string 'DUPLICATED_PACKAGE_SEARCH_KEY'
     */
    const VALUE_DUPLICATED_PACKAGE_SEARCH_KEY = 'DUPLICATED_PACKAGE_SEARCH_KEY';
    /**
     * Constant for value 'DUPLICATED_PARCEL_SEARCH_KEY'
     * @return string 'DUPLICATED_PARCEL_SEARCH_KEY'
     */
    const VALUE_DUPLICATED_PARCEL_SEARCH_KEY = 'DUPLICATED_PARCEL_SEARCH_KEY';
    /**
     * Constant for value 'DISALLOWED_FID'
     * @return string 'DISALLOWED_FID'
     */
    const VALUE_DISALLOWED_FID = 'DISALLOWED_FID';
    /**
     * Constant for value 'DUPLICATED_WAYBILL'
     * @return string 'DUPLICATED_WAYBILL'
     */
    const VALUE_DUPLICATED_WAYBILL = 'DUPLICATED_WAYBILL';
    /**
     * Constant for value 'UNSUPPORTED_LANG_CODE'
     * @return string 'UNSUPPORTED_LANG_CODE'
     */
    const VALUE_UNSUPPORTED_LANG_CODE = 'UNSUPPORTED_LANG_CODE';
    /**
     * Constant for value 'ERROR_NO_FID_PERMISSION'
     * @return string 'ERROR_NO_FID_PERMISSION'
     */
    const VALUE_ERROR_NO_FID_PERMISSION = 'ERROR_NO_FID_PERMISSION';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_UNKNOWN_ERROR
     * @uses self::VALUE_DB_ERROR
     * @uses self::VALUE_INCORRECT_DATA
     * @uses self::VALUE_NOT_PROCESSED
     * @uses self::VALUE_DUPLICATED_PACKAGE_SEARCH_KEY
     * @uses self::VALUE_DUPLICATED_PARCEL_SEARCH_KEY
     * @uses self::VALUE_DISALLOWED_FID
     * @uses self::VALUE_DUPLICATED_WAYBILL
     * @uses self::VALUE_UNSUPPORTED_LANG_CODE
     * @uses self::VALUE_ERROR_NO_FID_PERMISSION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_UNKNOWN_ERROR,
            self::VALUE_DB_ERROR,
            self::VALUE_INCORRECT_DATA,
            self::VALUE_NOT_PROCESSED,
            self::VALUE_DUPLICATED_PACKAGE_SEARCH_KEY,
            self::VALUE_DUPLICATED_PARCEL_SEARCH_KEY,
            self::VALUE_DISALLOWED_FID,
            self::VALUE_DUPLICATED_WAYBILL,
            self::VALUE_UNSUPPORTED_LANG_CODE,
            self::VALUE_ERROR_NO_FID_PERMISSION,
        );
    }
}
