<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TCustomerResult StructType
 * @subpackage Structs
 */
class TCustomerResult extends AbstractStructBase
{
    /**
     * The Accountcode
     * @var string
     */
    public $Accountcode;
    /**
     * The Resultcode
     * @var int
     */
    public $Resultcode;
    /**
     * The ResultMessege
     * @var string
     */
    public $ResultMessege;
    /**
     * Constructor method for TCustomerResult
     * @uses TCustomerResult::setAccountcode()
     * @uses TCustomerResult::setResultcode()
     * @uses TCustomerResult::setResultMessege()
     * @param string $accountcode
     * @param int $resultcode
     * @param string $resultMessege
     */
    public function __construct($accountcode = null, $resultcode = null, $resultMessege = null)
    {
        $this
            ->setAccountcode($accountcode)
            ->setResultcode($resultcode)
            ->setResultMessege($resultMessege);
    }
    /**
     * Get Accountcode value
     * @return string|null
     */
    public function getAccountcode()
    {
        return $this->Accountcode;
    }
    /**
     * Set Accountcode value
     * @param string $accountcode
     * @return \tk_\StructType\TCustomerResult
     */
    public function setAccountcode($accountcode = null)
    {
        // validation for constraint: string
        if (!is_null($accountcode) && !is_string($accountcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountcode, true), gettype($accountcode)), __LINE__);
        }
        $this->Accountcode = $accountcode;
        return $this;
    }
    /**
     * Get Resultcode value
     * @return int|null
     */
    public function getResultcode()
    {
        return $this->Resultcode;
    }
    /**
     * Set Resultcode value
     * @param int $resultcode
     * @return \tk_\StructType\TCustomerResult
     */
    public function setResultcode($resultcode = null)
    {
        // validation for constraint: int
        if (!is_null($resultcode) && !(is_int($resultcode) || ctype_digit($resultcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultcode, true), gettype($resultcode)), __LINE__);
        }
        $this->Resultcode = $resultcode;
        return $this;
    }
    /**
     * Get ResultMessege value
     * @return string|null
     */
    public function getResultMessege()
    {
        return $this->ResultMessege;
    }
    /**
     * Set ResultMessege value
     * @param string $resultMessege
     * @return \tk_\StructType\TCustomerResult
     */
    public function setResultMessege($resultMessege = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessege) && !is_string($resultMessege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessege, true), gettype($resultMessege)), __LINE__);
        }
        $this->ResultMessege = $resultMessege;
        return $this;
    }
}
