<?php

namespace tk_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Add ServiceType
 * @subpackage Services
 */
class Add extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AddCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \tk_\StructType\TCustomer $customerRec
     * @return \tk_\StructType\TCustomerResult|bool
     */
    public function AddCustomer(\tk_\StructType\TCustomer $customerRec)
    {
        try {
            $this->setResult($this->getSoapClient()->AddCustomer($customerRec));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddSale
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $autoCreateCustomer
     * @param string $orderNumber
     * @param \tk_\StructType\TCustomer $customerRec
     * @param \tk_\StructType\TStockSaleType[] $items
     * @param \tk_\StructType\TTender[] $tenders
     * @return \tk_\StructType\TInvoiceResult|bool
     */
    public function AddSale($autoCreateCustomer, $orderNumber, \tk_\StructType\TCustomer $customerRec, array $items, array $tenders)
    {
        try {
            $this->setResult($this->getSoapClient()->AddSale($autoCreateCustomer, $orderNumber, $customerRec, $items, $tenders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddRefund
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $autoCreateCustomer
     * @param string $orderNumber
     * @param \tk_\StructType\TCustomer $customerRec
     * @param \tk_\StructType\TStockSaleType[] $items
     * @param \tk_\StructType\TTender[] $tenders
     * @return \tk_\StructType\TInvoiceResult|bool
     */
    public function AddRefund($autoCreateCustomer, $orderNumber, \tk_\StructType\TCustomer $customerRec, array $items, array $tenders)
    {
        try {
            $this->setResult($this->getSoapClient()->AddRefund($autoCreateCustomer, $orderNumber, $customerRec, $items, $tenders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AddOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $autoCreateCustomer
     * @param string $orderNumber
     * @param \tk_\StructType\TCustomer $customerRec
     * @param \tk_\StructType\TStockSaleType[] $items
     * @param \tk_\StructType\TTender[] $tenders
     * @param string $loyalty
     * @return \tk_\StructType\TOrderResult|bool
     */
    public function AddOrder($autoCreateCustomer, $orderNumber, \tk_\StructType\TCustomer $customerRec, array $items, array $tenders, $loyalty)
    {
        try {
            $this->setResult($this->getSoapClient()->AddOrder($autoCreateCustomer, $orderNumber, $customerRec, $items, $tenders, $loyalty));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \tk_\StructType\TCustomerResult|\tk_\StructType\TInvoiceResult|\tk_\StructType\TOrderResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
