<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TSize StructType
 * @subpackage Structs
 */
class TSize extends AbstractStructBase
{
    /**
     * The ColourCode
     * @var string
     */
    public $ColourCode;
    /**
     * The ColourDescription
     * @var string
     */
    public $ColourDescription;
    /**
     * The SizeCode
     * @var string
     */
    public $SizeCode;
    /**
     * The SizeDescription
     * @var string
     */
    public $SizeDescription;
    /**
     * The Stores
     * Meta information extracted from the WSDL
     * - arrayType: ns1:TStoreSOH[]
     * - base: soapenc:Array
     * - ref: soapenc:arrayType
     * @var \tk_\StructType\TStoreSOH[]
     */
    public $Stores;
    /**
     * Constructor method for TSize
     * @uses TSize::setColourCode()
     * @uses TSize::setColourDescription()
     * @uses TSize::setSizeCode()
     * @uses TSize::setSizeDescription()
     * @uses TSize::setStores()
     * @param string $colourCode
     * @param string $colourDescription
     * @param string $sizeCode
     * @param string $sizeDescription
     * @param \tk_\StructType\TStoreSOH[] $stores
     */
    public function __construct($colourCode = null, $colourDescription = null, $sizeCode = null, $sizeDescription = null, array $stores = array())
    {
        $this
            ->setColourCode($colourCode)
            ->setColourDescription($colourDescription)
            ->setSizeCode($sizeCode)
            ->setSizeDescription($sizeDescription)
            ->setStores($stores);
    }
    /**
     * Get ColourCode value
     * @return string|null
     */
    public function getColourCode()
    {
        return $this->ColourCode;
    }
    /**
     * Set ColourCode value
     * @param string $colourCode
     * @return \tk_\StructType\TSize
     */
    public function setColourCode($colourCode = null)
    {
        // validation for constraint: string
        if (!is_null($colourCode) && !is_string($colourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourCode, true), gettype($colourCode)), __LINE__);
        }
        $this->ColourCode = $colourCode;
        return $this;
    }
    /**
     * Get ColourDescription value
     * @return string|null
     */
    public function getColourDescription()
    {
        return $this->ColourDescription;
    }
    /**
     * Set ColourDescription value
     * @param string $colourDescription
     * @return \tk_\StructType\TSize
     */
    public function setColourDescription($colourDescription = null)
    {
        // validation for constraint: string
        if (!is_null($colourDescription) && !is_string($colourDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourDescription, true), gettype($colourDescription)), __LINE__);
        }
        $this->ColourDescription = $colourDescription;
        return $this;
    }
    /**
     * Get SizeCode value
     * @return string|null
     */
    public function getSizeCode()
    {
        return $this->SizeCode;
    }
    /**
     * Set SizeCode value
     * @param string $sizeCode
     * @return \tk_\StructType\TSize
     */
    public function setSizeCode($sizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($sizeCode) && !is_string($sizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeCode, true), gettype($sizeCode)), __LINE__);
        }
        $this->SizeCode = $sizeCode;
        return $this;
    }
    /**
     * Get SizeDescription value
     * @return string|null
     */
    public function getSizeDescription()
    {
        return $this->SizeDescription;
    }
    /**
     * Set SizeDescription value
     * @param string $sizeDescription
     * @return \tk_\StructType\TSize
     */
    public function setSizeDescription($sizeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($sizeDescription) && !is_string($sizeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeDescription, true), gettype($sizeDescription)), __LINE__);
        }
        $this->SizeDescription = $sizeDescription;
        return $this;
    }
    /**
     * Get Stores value
     * @return \tk_\StructType\TStoreSOH[]|null
     */
    public function getStores()
    {
        return $this->Stores;
    }
    /**
     * This method is responsible for validating the values passed to the setStores method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStores method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStoresForArrayConstraintsFromSetStores(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tSizeStoresItem) {
            // validation for constraint: itemType
            if (!$tSizeStoresItem instanceof \tk_\StructType\TStoreSOH) {
                $invalidValues[] = is_object($tSizeStoresItem) ? get_class($tSizeStoresItem) : sprintf('%s(%s)', gettype($tSizeStoresItem), var_export($tSizeStoresItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stores property can only contain items of type \tk_\StructType\TStoreSOH, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stores value
     * @throws \InvalidArgumentException
     * @param \tk_\StructType\TStoreSOH[] $stores
     * @return \tk_\StructType\TSize
     */
    public function setStores(array $stores = array())
    {
        // validation for constraint: array
        if ('' !== ($storesArrayErrorMessage = self::validateStoresForArrayConstraintsFromSetStores($stores))) {
            throw new \InvalidArgumentException($storesArrayErrorMessage, __LINE__);
        }
        $this->Stores = $stores;
        return $this;
    }
    /**
     * Add item to Stores value
     * @throws \InvalidArgumentException
     * @param \tk_\StructType\TStoreSOH $item
     * @return \tk_\StructType\TSize
     */
    public function addToStores(\tk_\StructType\TStoreSOH $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \tk_\StructType\TStoreSOH) {
            throw new \InvalidArgumentException(sprintf('The Stores property can only contain items of type \tk_\StructType\TStoreSOH, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stores[] = $item;
        return $this;
    }
}
