<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TOrderResult StructType
 * @subpackage Structs
 */
class TOrderResult extends AbstractStructBase
{
    /**
     * The OrderNo
     * @var string
     */
    public $OrderNo;
    /**
     * The Accountcode
     * @var string
     */
    public $Accountcode;
    /**
     * The Resultcode
     * @var int
     */
    public $Resultcode;
    /**
     * The ResultMessege
     * @var string
     */
    public $ResultMessege;
    /**
     * Constructor method for TOrderResult
     * @uses TOrderResult::setOrderNo()
     * @uses TOrderResult::setAccountcode()
     * @uses TOrderResult::setResultcode()
     * @uses TOrderResult::setResultMessege()
     * @param string $orderNo
     * @param string $accountcode
     * @param int $resultcode
     * @param string $resultMessege
     */
    public function __construct($orderNo = null, $accountcode = null, $resultcode = null, $resultMessege = null)
    {
        $this
            ->setOrderNo($orderNo)
            ->setAccountcode($accountcode)
            ->setResultcode($resultcode)
            ->setResultMessege($resultMessege);
    }
    /**
     * Get OrderNo value
     * @return string|null
     */
    public function getOrderNo()
    {
        return $this->OrderNo;
    }
    /**
     * Set OrderNo value
     * @param string $orderNo
     * @return \tk_\StructType\TOrderResult
     */
    public function setOrderNo($orderNo = null)
    {
        // validation for constraint: string
        if (!is_null($orderNo) && !is_string($orderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNo, true), gettype($orderNo)), __LINE__);
        }
        $this->OrderNo = $orderNo;
        return $this;
    }
    /**
     * Get Accountcode value
     * @return string|null
     */
    public function getAccountcode()
    {
        return $this->Accountcode;
    }
    /**
     * Set Accountcode value
     * @param string $accountcode
     * @return \tk_\StructType\TOrderResult
     */
    public function setAccountcode($accountcode = null)
    {
        // validation for constraint: string
        if (!is_null($accountcode) && !is_string($accountcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountcode, true), gettype($accountcode)), __LINE__);
        }
        $this->Accountcode = $accountcode;
        return $this;
    }
    /**
     * Get Resultcode value
     * @return int|null
     */
    public function getResultcode()
    {
        return $this->Resultcode;
    }
    /**
     * Set Resultcode value
     * @param int $resultcode
     * @return \tk_\StructType\TOrderResult
     */
    public function setResultcode($resultcode = null)
    {
        // validation for constraint: int
        if (!is_null($resultcode) && !(is_int($resultcode) || ctype_digit($resultcode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultcode, true), gettype($resultcode)), __LINE__);
        }
        $this->Resultcode = $resultcode;
        return $this;
    }
    /**
     * Get ResultMessege value
     * @return string|null
     */
    public function getResultMessege()
    {
        return $this->ResultMessege;
    }
    /**
     * Set ResultMessege value
     * @param string $resultMessege
     * @return \tk_\StructType\TOrderResult
     */
    public function setResultMessege($resultMessege = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessege) && !is_string($resultMessege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessege, true), gettype($resultMessege)), __LINE__);
        }
        $this->ResultMessege = $resultMessege;
        return $this;
    }
}
