<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TGiftCardType StructType
 * @subpackage Structs
 */
class TGiftCardType extends AbstractStructBase
{
    /**
     * The CardNumber
     * @var string
     */
    public $CardNumber;
    /**
     * The CardDescription
     * @var string
     */
    public $CardDescription;
    /**
     * The Balance
     * @var float
     */
    public $Balance;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for TGiftCardType
     * @uses TGiftCardType::setCardNumber()
     * @uses TGiftCardType::setCardDescription()
     * @uses TGiftCardType::setBalance()
     * @uses TGiftCardType::setStatus()
     * @param string $cardNumber
     * @param string $cardDescription
     * @param float $balance
     * @param string $status
     */
    public function __construct($cardNumber = null, $cardDescription = null, $balance = null, $status = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardDescription($cardDescription)
            ->setBalance($balance)
            ->setStatus($status);
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \tk_\StructType\TGiftCardType
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardDescription value
     * @return string|null
     */
    public function getCardDescription()
    {
        return $this->CardDescription;
    }
    /**
     * Set CardDescription value
     * @param string $cardDescription
     * @return \tk_\StructType\TGiftCardType
     */
    public function setCardDescription($cardDescription = null)
    {
        // validation for constraint: string
        if (!is_null($cardDescription) && !is_string($cardDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardDescription, true), gettype($cardDescription)), __LINE__);
        }
        $this->CardDescription = $cardDescription;
        return $this;
    }
    /**
     * Get Balance value
     * @return float|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param float $balance
     * @return \tk_\StructType\TGiftCardType
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \tk_\StructType\TGiftCardType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
