<?php

namespace tk_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $accountNo
     * @param string $mobileNo
     * @return \tk_\StructType\TCustomer|bool
     */
    public function GetCustomer($accountNo, $mobileNo)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomer($accountNo, $mobileNo));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetImage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $itemCode
     * @return string|bool
     */
    public function GetImage($itemCode)
    {
        try {
            $this->setResult($this->getSoapClient()->GetImage($itemCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNotes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $itemCode
     * @return string|bool
     */
    public function GetNotes($itemCode)
    {
        try {
            $this->setResult($this->getSoapClient()->GetNotes($itemCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTenderTypes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \tk_\StructType\TTenderTypes[]|bool
     */
    public function GetTenderTypes()
    {
        try {
            $this->setResult($this->getSoapClient()->GetTenderTypes());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return string|\tk_\StructType\TCustomer|\tk_\StructType\TTenderTypes[]
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
