<?php

namespace tk_\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $originalOrderNumber
     * @param \tk_\StructType\TTender[] $tenders
     * @return \tk_\StructType\TOrderResult|bool
     */
    public function CancelOrder($originalOrderNumber, array $tenders)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelOrder($originalOrderNumber, $tenders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \tk_\StructType\TOrderResult
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
