<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TStockAvailableType StructType
 * @subpackage Structs
 */
class TStockAvailableType extends AbstractStructBase
{
    /**
     * The ItemCode
     * @var string
     */
    public $ItemCode;
    /**
     * The ColourCode
     * @var string
     */
    public $ColourCode;
    /**
     * The ColourDescription
     * @var string
     */
    public $ColourDescription;
    /**
     * The SizeCode
     * @var string
     */
    public $SizeCode;
    /**
     * The SizeDescription
     * @var string
     */
    public $SizeDescription;
    /**
     * The StoreID
     * @var string
     */
    public $StoreID;
    /**
     * The QtyAvailable
     * @var float
     */
    public $QtyAvailable;
    /**
     * The ExclSellPrice
     * @var float
     */
    public $ExclSellPrice;
    /**
     * The InclSellPrice
     * @var float
     */
    public $InclSellPrice;
    /**
     * The ExclPromoPrice
     * @var float
     */
    public $ExclPromoPrice;
    /**
     * The InclPromoPrice
     * @var float
     */
    public $InclPromoPrice;
    /**
     * Constructor method for TStockAvailableType
     * @uses TStockAvailableType::setItemCode()
     * @uses TStockAvailableType::setColourCode()
     * @uses TStockAvailableType::setColourDescription()
     * @uses TStockAvailableType::setSizeCode()
     * @uses TStockAvailableType::setSizeDescription()
     * @uses TStockAvailableType::setStoreID()
     * @uses TStockAvailableType::setQtyAvailable()
     * @uses TStockAvailableType::setExclSellPrice()
     * @uses TStockAvailableType::setInclSellPrice()
     * @uses TStockAvailableType::setExclPromoPrice()
     * @uses TStockAvailableType::setInclPromoPrice()
     * @param string $itemCode
     * @param string $colourCode
     * @param string $colourDescription
     * @param string $sizeCode
     * @param string $sizeDescription
     * @param string $storeID
     * @param float $qtyAvailable
     * @param float $exclSellPrice
     * @param float $inclSellPrice
     * @param float $exclPromoPrice
     * @param float $inclPromoPrice
     */
    public function __construct($itemCode = null, $colourCode = null, $colourDescription = null, $sizeCode = null, $sizeDescription = null, $storeID = null, $qtyAvailable = null, $exclSellPrice = null, $inclSellPrice = null, $exclPromoPrice = null, $inclPromoPrice = null)
    {
        $this
            ->setItemCode($itemCode)
            ->setColourCode($colourCode)
            ->setColourDescription($colourDescription)
            ->setSizeCode($sizeCode)
            ->setSizeDescription($sizeDescription)
            ->setStoreID($storeID)
            ->setQtyAvailable($qtyAvailable)
            ->setExclSellPrice($exclSellPrice)
            ->setInclSellPrice($inclSellPrice)
            ->setExclPromoPrice($exclPromoPrice)
            ->setInclPromoPrice($inclPromoPrice);
    }
    /**
     * Get ItemCode value
     * @return string|null
     */
    public function getItemCode()
    {
        return $this->ItemCode;
    }
    /**
     * Set ItemCode value
     * @param string $itemCode
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setItemCode($itemCode = null)
    {
        // validation for constraint: string
        if (!is_null($itemCode) && !is_string($itemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCode, true), gettype($itemCode)), __LINE__);
        }
        $this->ItemCode = $itemCode;
        return $this;
    }
    /**
     * Get ColourCode value
     * @return string|null
     */
    public function getColourCode()
    {
        return $this->ColourCode;
    }
    /**
     * Set ColourCode value
     * @param string $colourCode
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setColourCode($colourCode = null)
    {
        // validation for constraint: string
        if (!is_null($colourCode) && !is_string($colourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourCode, true), gettype($colourCode)), __LINE__);
        }
        $this->ColourCode = $colourCode;
        return $this;
    }
    /**
     * Get ColourDescription value
     * @return string|null
     */
    public function getColourDescription()
    {
        return $this->ColourDescription;
    }
    /**
     * Set ColourDescription value
     * @param string $colourDescription
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setColourDescription($colourDescription = null)
    {
        // validation for constraint: string
        if (!is_null($colourDescription) && !is_string($colourDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colourDescription, true), gettype($colourDescription)), __LINE__);
        }
        $this->ColourDescription = $colourDescription;
        return $this;
    }
    /**
     * Get SizeCode value
     * @return string|null
     */
    public function getSizeCode()
    {
        return $this->SizeCode;
    }
    /**
     * Set SizeCode value
     * @param string $sizeCode
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setSizeCode($sizeCode = null)
    {
        // validation for constraint: string
        if (!is_null($sizeCode) && !is_string($sizeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeCode, true), gettype($sizeCode)), __LINE__);
        }
        $this->SizeCode = $sizeCode;
        return $this;
    }
    /**
     * Get SizeDescription value
     * @return string|null
     */
    public function getSizeDescription()
    {
        return $this->SizeDescription;
    }
    /**
     * Set SizeDescription value
     * @param string $sizeDescription
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setSizeDescription($sizeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($sizeDescription) && !is_string($sizeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sizeDescription, true), gettype($sizeDescription)), __LINE__);
        }
        $this->SizeDescription = $sizeDescription;
        return $this;
    }
    /**
     * Get StoreID value
     * @return string|null
     */
    public function getStoreID()
    {
        return $this->StoreID;
    }
    /**
     * Set StoreID value
     * @param string $storeID
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setStoreID($storeID = null)
    {
        // validation for constraint: string
        if (!is_null($storeID) && !is_string($storeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($storeID, true), gettype($storeID)), __LINE__);
        }
        $this->StoreID = $storeID;
        return $this;
    }
    /**
     * Get QtyAvailable value
     * @return float|null
     */
    public function getQtyAvailable()
    {
        return $this->QtyAvailable;
    }
    /**
     * Set QtyAvailable value
     * @param float $qtyAvailable
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setQtyAvailable($qtyAvailable = null)
    {
        // validation for constraint: float
        if (!is_null($qtyAvailable) && !(is_float($qtyAvailable) || is_numeric($qtyAvailable))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qtyAvailable, true), gettype($qtyAvailable)), __LINE__);
        }
        $this->QtyAvailable = $qtyAvailable;
        return $this;
    }
    /**
     * Get ExclSellPrice value
     * @return float|null
     */
    public function getExclSellPrice()
    {
        return $this->ExclSellPrice;
    }
    /**
     * Set ExclSellPrice value
     * @param float $exclSellPrice
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setExclSellPrice($exclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($exclSellPrice) && !(is_float($exclSellPrice) || is_numeric($exclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exclSellPrice, true), gettype($exclSellPrice)), __LINE__);
        }
        $this->ExclSellPrice = $exclSellPrice;
        return $this;
    }
    /**
     * Get InclSellPrice value
     * @return float|null
     */
    public function getInclSellPrice()
    {
        return $this->InclSellPrice;
    }
    /**
     * Set InclSellPrice value
     * @param float $inclSellPrice
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setInclSellPrice($inclSellPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclSellPrice) && !(is_float($inclSellPrice) || is_numeric($inclSellPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclSellPrice, true), gettype($inclSellPrice)), __LINE__);
        }
        $this->InclSellPrice = $inclSellPrice;
        return $this;
    }
    /**
     * Get ExclPromoPrice value
     * @return float|null
     */
    public function getExclPromoPrice()
    {
        return $this->ExclPromoPrice;
    }
    /**
     * Set ExclPromoPrice value
     * @param float $exclPromoPrice
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setExclPromoPrice($exclPromoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($exclPromoPrice) && !(is_float($exclPromoPrice) || is_numeric($exclPromoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exclPromoPrice, true), gettype($exclPromoPrice)), __LINE__);
        }
        $this->ExclPromoPrice = $exclPromoPrice;
        return $this;
    }
    /**
     * Get InclPromoPrice value
     * @return float|null
     */
    public function getInclPromoPrice()
    {
        return $this->InclPromoPrice;
    }
    /**
     * Set InclPromoPrice value
     * @param float $inclPromoPrice
     * @return \tk_\StructType\TStockAvailableType
     */
    public function setInclPromoPrice($inclPromoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($inclPromoPrice) && !(is_float($inclPromoPrice) || is_numeric($inclPromoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($inclPromoPrice, true), gettype($inclPromoPrice)), __LINE__);
        }
        $this->InclPromoPrice = $inclPromoPrice;
        return $this;
    }
}
