<?php

namespace tk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TCustomer StructType
 * @subpackage Structs
 */
class TCustomer extends AbstractStructBase
{
    /**
     * The Accountcode
     * @var string
     */
    public $Accountcode;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The Initials
     * @var string
     */
    public $Initials;
    /**
     * The Surname
     * @var string
     */
    public $Surname;
    /**
     * The ContactName
     * @var string
     */
    public $ContactName;
    /**
     * The IDNumber
     * @var string
     */
    public $IDNumber;
    /**
     * The DateOfBirth
     * @var string
     */
    public $DateOfBirth;
    /**
     * The ResidentialAddressLine1
     * @var string
     */
    public $ResidentialAddressLine1;
    /**
     * The ResidentialAddressLine2
     * @var string
     */
    public $ResidentialAddressLine2;
    /**
     * The ResidentialSuburb
     * @var string
     */
    public $ResidentialSuburb;
    /**
     * The ResidentialTown
     * @var string
     */
    public $ResidentialTown;
    /**
     * The ResidentialPostalCode
     * @var string
     */
    public $ResidentialPostalCode;
    /**
     * The PostalAddressLine1
     * @var string
     */
    public $PostalAddressLine1;
    /**
     * The PostalAddressLine2
     * @var string
     */
    public $PostalAddressLine2;
    /**
     * The PostalSuburb
     * @var string
     */
    public $PostalSuburb;
    /**
     * The PostalTown
     * @var string
     */
    public $PostalTown;
    /**
     * The PostalCode
     * @var string
     */
    public $PostalCode;
    /**
     * The MobileNo
     * @var string
     */
    public $MobileNo;
    /**
     * The EmailAddress
     * @var string
     */
    public $EmailAddress;
    /**
     * The UserField1
     * @var string
     */
    public $UserField1;
    /**
     * The UserField2
     * @var string
     */
    public $UserField2;
    /**
     * The CustomerType
     * @var int
     */
    public $CustomerType;
    /**
     * The LoyaltyPoints
     * @var int
     */
    public $LoyaltyPoints;
    /**
     * The LoyaltyPointsValue
     * @var float
     */
    public $LoyaltyPointsValue;
    /**
     * The LoyaltyDiscount
     * @var float
     */
    public $LoyaltyDiscount;
    /**
     * The LoyaltyID
     * @var int
     */
    public $LoyaltyID;
    /**
     * Constructor method for TCustomer
     * @uses TCustomer::setAccountcode()
     * @uses TCustomer::setTitle()
     * @uses TCustomer::setInitials()
     * @uses TCustomer::setSurname()
     * @uses TCustomer::setContactName()
     * @uses TCustomer::setIDNumber()
     * @uses TCustomer::setDateOfBirth()
     * @uses TCustomer::setResidentialAddressLine1()
     * @uses TCustomer::setResidentialAddressLine2()
     * @uses TCustomer::setResidentialSuburb()
     * @uses TCustomer::setResidentialTown()
     * @uses TCustomer::setResidentialPostalCode()
     * @uses TCustomer::setPostalAddressLine1()
     * @uses TCustomer::setPostalAddressLine2()
     * @uses TCustomer::setPostalSuburb()
     * @uses TCustomer::setPostalTown()
     * @uses TCustomer::setPostalCode()
     * @uses TCustomer::setMobileNo()
     * @uses TCustomer::setEmailAddress()
     * @uses TCustomer::setUserField1()
     * @uses TCustomer::setUserField2()
     * @uses TCustomer::setCustomerType()
     * @uses TCustomer::setLoyaltyPoints()
     * @uses TCustomer::setLoyaltyPointsValue()
     * @uses TCustomer::setLoyaltyDiscount()
     * @uses TCustomer::setLoyaltyID()
     * @param string $accountcode
     * @param string $title
     * @param string $initials
     * @param string $surname
     * @param string $contactName
     * @param string $iDNumber
     * @param string $dateOfBirth
     * @param string $residentialAddressLine1
     * @param string $residentialAddressLine2
     * @param string $residentialSuburb
     * @param string $residentialTown
     * @param string $residentialPostalCode
     * @param string $postalAddressLine1
     * @param string $postalAddressLine2
     * @param string $postalSuburb
     * @param string $postalTown
     * @param string $postalCode
     * @param string $mobileNo
     * @param string $emailAddress
     * @param string $userField1
     * @param string $userField2
     * @param int $customerType
     * @param int $loyaltyPoints
     * @param float $loyaltyPointsValue
     * @param float $loyaltyDiscount
     * @param int $loyaltyID
     */
    public function __construct($accountcode = null, $title = null, $initials = null, $surname = null, $contactName = null, $iDNumber = null, $dateOfBirth = null, $residentialAddressLine1 = null, $residentialAddressLine2 = null, $residentialSuburb = null, $residentialTown = null, $residentialPostalCode = null, $postalAddressLine1 = null, $postalAddressLine2 = null, $postalSuburb = null, $postalTown = null, $postalCode = null, $mobileNo = null, $emailAddress = null, $userField1 = null, $userField2 = null, $customerType = null, $loyaltyPoints = null, $loyaltyPointsValue = null, $loyaltyDiscount = null, $loyaltyID = null)
    {
        $this
            ->setAccountcode($accountcode)
            ->setTitle($title)
            ->setInitials($initials)
            ->setSurname($surname)
            ->setContactName($contactName)
            ->setIDNumber($iDNumber)
            ->setDateOfBirth($dateOfBirth)
            ->setResidentialAddressLine1($residentialAddressLine1)
            ->setResidentialAddressLine2($residentialAddressLine2)
            ->setResidentialSuburb($residentialSuburb)
            ->setResidentialTown($residentialTown)
            ->setResidentialPostalCode($residentialPostalCode)
            ->setPostalAddressLine1($postalAddressLine1)
            ->setPostalAddressLine2($postalAddressLine2)
            ->setPostalSuburb($postalSuburb)
            ->setPostalTown($postalTown)
            ->setPostalCode($postalCode)
            ->setMobileNo($mobileNo)
            ->setEmailAddress($emailAddress)
            ->setUserField1($userField1)
            ->setUserField2($userField2)
            ->setCustomerType($customerType)
            ->setLoyaltyPoints($loyaltyPoints)
            ->setLoyaltyPointsValue($loyaltyPointsValue)
            ->setLoyaltyDiscount($loyaltyDiscount)
            ->setLoyaltyID($loyaltyID);
    }
    /**
     * Get Accountcode value
     * @return string|null
     */
    public function getAccountcode()
    {
        return $this->Accountcode;
    }
    /**
     * Set Accountcode value
     * @param string $accountcode
     * @return \tk_\StructType\TCustomer
     */
    public function setAccountcode($accountcode = null)
    {
        // validation for constraint: string
        if (!is_null($accountcode) && !is_string($accountcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountcode, true), gettype($accountcode)), __LINE__);
        }
        $this->Accountcode = $accountcode;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \tk_\StructType\TCustomer
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Initials value
     * @return string|null
     */
    public function getInitials()
    {
        return $this->Initials;
    }
    /**
     * Set Initials value
     * @param string $initials
     * @return \tk_\StructType\TCustomer
     */
    public function setInitials($initials = null)
    {
        // validation for constraint: string
        if (!is_null($initials) && !is_string($initials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initials, true), gettype($initials)), __LINE__);
        }
        $this->Initials = $initials;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \tk_\StructType\TCustomer
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \tk_\StructType\TCustomer
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get IDNumber value
     * @return string|null
     */
    public function getIDNumber()
    {
        return $this->IDNumber;
    }
    /**
     * Set IDNumber value
     * @param string $iDNumber
     * @return \tk_\StructType\TCustomer
     */
    public function setIDNumber($iDNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iDNumber) && !is_string($iDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDNumber, true), gettype($iDNumber)), __LINE__);
        }
        $this->IDNumber = $iDNumber;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \tk_\StructType\TCustomer
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get ResidentialAddressLine1 value
     * @return string|null
     */
    public function getResidentialAddressLine1()
    {
        return $this->ResidentialAddressLine1;
    }
    /**
     * Set ResidentialAddressLine1 value
     * @param string $residentialAddressLine1
     * @return \tk_\StructType\TCustomer
     */
    public function setResidentialAddressLine1($residentialAddressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($residentialAddressLine1) && !is_string($residentialAddressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialAddressLine1, true), gettype($residentialAddressLine1)), __LINE__);
        }
        $this->ResidentialAddressLine1 = $residentialAddressLine1;
        return $this;
    }
    /**
     * Get ResidentialAddressLine2 value
     * @return string|null
     */
    public function getResidentialAddressLine2()
    {
        return $this->ResidentialAddressLine2;
    }
    /**
     * Set ResidentialAddressLine2 value
     * @param string $residentialAddressLine2
     * @return \tk_\StructType\TCustomer
     */
    public function setResidentialAddressLine2($residentialAddressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($residentialAddressLine2) && !is_string($residentialAddressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialAddressLine2, true), gettype($residentialAddressLine2)), __LINE__);
        }
        $this->ResidentialAddressLine2 = $residentialAddressLine2;
        return $this;
    }
    /**
     * Get ResidentialSuburb value
     * @return string|null
     */
    public function getResidentialSuburb()
    {
        return $this->ResidentialSuburb;
    }
    /**
     * Set ResidentialSuburb value
     * @param string $residentialSuburb
     * @return \tk_\StructType\TCustomer
     */
    public function setResidentialSuburb($residentialSuburb = null)
    {
        // validation for constraint: string
        if (!is_null($residentialSuburb) && !is_string($residentialSuburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialSuburb, true), gettype($residentialSuburb)), __LINE__);
        }
        $this->ResidentialSuburb = $residentialSuburb;
        return $this;
    }
    /**
     * Get ResidentialTown value
     * @return string|null
     */
    public function getResidentialTown()
    {
        return $this->ResidentialTown;
    }
    /**
     * Set ResidentialTown value
     * @param string $residentialTown
     * @return \tk_\StructType\TCustomer
     */
    public function setResidentialTown($residentialTown = null)
    {
        // validation for constraint: string
        if (!is_null($residentialTown) && !is_string($residentialTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialTown, true), gettype($residentialTown)), __LINE__);
        }
        $this->ResidentialTown = $residentialTown;
        return $this;
    }
    /**
     * Get ResidentialPostalCode value
     * @return string|null
     */
    public function getResidentialPostalCode()
    {
        return $this->ResidentialPostalCode;
    }
    /**
     * Set ResidentialPostalCode value
     * @param string $residentialPostalCode
     * @return \tk_\StructType\TCustomer
     */
    public function setResidentialPostalCode($residentialPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($residentialPostalCode) && !is_string($residentialPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residentialPostalCode, true), gettype($residentialPostalCode)), __LINE__);
        }
        $this->ResidentialPostalCode = $residentialPostalCode;
        return $this;
    }
    /**
     * Get PostalAddressLine1 value
     * @return string|null
     */
    public function getPostalAddressLine1()
    {
        return $this->PostalAddressLine1;
    }
    /**
     * Set PostalAddressLine1 value
     * @param string $postalAddressLine1
     * @return \tk_\StructType\TCustomer
     */
    public function setPostalAddressLine1($postalAddressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($postalAddressLine1) && !is_string($postalAddressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalAddressLine1, true), gettype($postalAddressLine1)), __LINE__);
        }
        $this->PostalAddressLine1 = $postalAddressLine1;
        return $this;
    }
    /**
     * Get PostalAddressLine2 value
     * @return string|null
     */
    public function getPostalAddressLine2()
    {
        return $this->PostalAddressLine2;
    }
    /**
     * Set PostalAddressLine2 value
     * @param string $postalAddressLine2
     * @return \tk_\StructType\TCustomer
     */
    public function setPostalAddressLine2($postalAddressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($postalAddressLine2) && !is_string($postalAddressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalAddressLine2, true), gettype($postalAddressLine2)), __LINE__);
        }
        $this->PostalAddressLine2 = $postalAddressLine2;
        return $this;
    }
    /**
     * Get PostalSuburb value
     * @return string|null
     */
    public function getPostalSuburb()
    {
        return $this->PostalSuburb;
    }
    /**
     * Set PostalSuburb value
     * @param string $postalSuburb
     * @return \tk_\StructType\TCustomer
     */
    public function setPostalSuburb($postalSuburb = null)
    {
        // validation for constraint: string
        if (!is_null($postalSuburb) && !is_string($postalSuburb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalSuburb, true), gettype($postalSuburb)), __LINE__);
        }
        $this->PostalSuburb = $postalSuburb;
        return $this;
    }
    /**
     * Get PostalTown value
     * @return string|null
     */
    public function getPostalTown()
    {
        return $this->PostalTown;
    }
    /**
     * Set PostalTown value
     * @param string $postalTown
     * @return \tk_\StructType\TCustomer
     */
    public function setPostalTown($postalTown = null)
    {
        // validation for constraint: string
        if (!is_null($postalTown) && !is_string($postalTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalTown, true), gettype($postalTown)), __LINE__);
        }
        $this->PostalTown = $postalTown;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \tk_\StructType\TCustomer
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get MobileNo value
     * @return string|null
     */
    public function getMobileNo()
    {
        return $this->MobileNo;
    }
    /**
     * Set MobileNo value
     * @param string $mobileNo
     * @return \tk_\StructType\TCustomer
     */
    public function setMobileNo($mobileNo = null)
    {
        // validation for constraint: string
        if (!is_null($mobileNo) && !is_string($mobileNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileNo, true), gettype($mobileNo)), __LINE__);
        }
        $this->MobileNo = $mobileNo;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \tk_\StructType\TCustomer
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get UserField1 value
     * @return string|null
     */
    public function getUserField1()
    {
        return $this->UserField1;
    }
    /**
     * Set UserField1 value
     * @param string $userField1
     * @return \tk_\StructType\TCustomer
     */
    public function setUserField1($userField1 = null)
    {
        // validation for constraint: string
        if (!is_null($userField1) && !is_string($userField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userField1, true), gettype($userField1)), __LINE__);
        }
        $this->UserField1 = $userField1;
        return $this;
    }
    /**
     * Get UserField2 value
     * @return string|null
     */
    public function getUserField2()
    {
        return $this->UserField2;
    }
    /**
     * Set UserField2 value
     * @param string $userField2
     * @return \tk_\StructType\TCustomer
     */
    public function setUserField2($userField2 = null)
    {
        // validation for constraint: string
        if (!is_null($userField2) && !is_string($userField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userField2, true), gettype($userField2)), __LINE__);
        }
        $this->UserField2 = $userField2;
        return $this;
    }
    /**
     * Get CustomerType value
     * @return int|null
     */
    public function getCustomerType()
    {
        return $this->CustomerType;
    }
    /**
     * Set CustomerType value
     * @param int $customerType
     * @return \tk_\StructType\TCustomer
     */
    public function setCustomerType($customerType = null)
    {
        // validation for constraint: int
        if (!is_null($customerType) && !(is_int($customerType) || ctype_digit($customerType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerType, true), gettype($customerType)), __LINE__);
        }
        $this->CustomerType = $customerType;
        return $this;
    }
    /**
     * Get LoyaltyPoints value
     * @return int|null
     */
    public function getLoyaltyPoints()
    {
        return $this->LoyaltyPoints;
    }
    /**
     * Set LoyaltyPoints value
     * @param int $loyaltyPoints
     * @return \tk_\StructType\TCustomer
     */
    public function setLoyaltyPoints($loyaltyPoints = null)
    {
        // validation for constraint: int
        if (!is_null($loyaltyPoints) && !(is_int($loyaltyPoints) || ctype_digit($loyaltyPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loyaltyPoints, true), gettype($loyaltyPoints)), __LINE__);
        }
        $this->LoyaltyPoints = $loyaltyPoints;
        return $this;
    }
    /**
     * Get LoyaltyPointsValue value
     * @return float|null
     */
    public function getLoyaltyPointsValue()
    {
        return $this->LoyaltyPointsValue;
    }
    /**
     * Set LoyaltyPointsValue value
     * @param float $loyaltyPointsValue
     * @return \tk_\StructType\TCustomer
     */
    public function setLoyaltyPointsValue($loyaltyPointsValue = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyPointsValue) && !(is_float($loyaltyPointsValue) || is_numeric($loyaltyPointsValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyPointsValue, true), gettype($loyaltyPointsValue)), __LINE__);
        }
        $this->LoyaltyPointsValue = $loyaltyPointsValue;
        return $this;
    }
    /**
     * Get LoyaltyDiscount value
     * @return float|null
     */
    public function getLoyaltyDiscount()
    {
        return $this->LoyaltyDiscount;
    }
    /**
     * Set LoyaltyDiscount value
     * @param float $loyaltyDiscount
     * @return \tk_\StructType\TCustomer
     */
    public function setLoyaltyDiscount($loyaltyDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyDiscount) && !(is_float($loyaltyDiscount) || is_numeric($loyaltyDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyDiscount, true), gettype($loyaltyDiscount)), __LINE__);
        }
        $this->LoyaltyDiscount = $loyaltyDiscount;
        return $this;
    }
    /**
     * Get LoyaltyID value
     * @return int|null
     */
    public function getLoyaltyID()
    {
        return $this->LoyaltyID;
    }
    /**
     * Set LoyaltyID value
     * @param int $loyaltyID
     * @return \tk_\StructType\TCustomer
     */
    public function setLoyaltyID($loyaltyID = null)
    {
        // validation for constraint: int
        if (!is_null($loyaltyID) && !(is_int($loyaltyID) || ctype_digit($loyaltyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loyaltyID, true), gettype($loyaltyID)), __LINE__);
        }
        $this->LoyaltyID = $loyaltyID;
        return $this;
    }
}
